/*
 * Decompiled with CFR 0.152.
 */
package org.epics.util.number;

import java.math.BigInteger;
import org.epics.util.number.UnsignedConversions;

public final class ULong
extends Number {
    private final long unsignedValue;

    public ULong(long unsignedValue) {
        this.unsignedValue = unsignedValue;
    }

    @Override
    public int intValue() {
        return (int)this.unsignedValue;
    }

    @Override
    public long longValue() {
        return this.unsignedValue;
    }

    @Override
    public float floatValue() {
        return UnsignedConversions.toFloat(this.unsignedValue);
    }

    @Override
    public double doubleValue() {
        return UnsignedConversions.toDouble(this.unsignedValue);
    }

    public BigInteger bigIntegerValue() {
        return UnsignedConversions.toBigInteger(this.unsignedValue);
    }

    public static ULong valueOf(long unsignedValue) {
        return new ULong(unsignedValue);
    }

    public static String toString(long unsignedValue) {
        return Long.toUnsignedString(unsignedValue, 10);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ULong) {
            return this.unsignedValue == ((ULong)obj).unsignedValue;
        }
        return false;
    }

    public int hashCode() {
        return Long.hashCode(this.unsignedValue);
    }

    public String toString() {
        return ULong.toString(this.unsignedValue);
    }
}

