/*
 * Decompiled with CFR 0.152.
 */
package org.epics.util.stats;

import org.epics.util.stats.Range;

public class Ranges {
    public static Range absRange(Range range) {
        if (range.getMinimum() >= 0.0 && range.getMaximum() >= 0.0) {
            return range;
        }
        if (range.getMinimum() < 0.0 && range.getMaximum() < 0.0) {
            return Range.of(-range.getMaximum(), -range.getMinimum());
        }
        return Range.of(0.0, Math.max(range.getMinimum(), range.getMaximum()));
    }

    public static double overlap(Range range, Range otherRange) {
        double minOverlap = Math.max(range.getMinimum(), otherRange.getMinimum());
        double maxOverlap = Math.min(range.getMaximum(), otherRange.getMaximum());
        double overlapWidth = maxOverlap - minOverlap;
        double rangeWidth = range.getMaximum() - range.getMinimum();
        double fraction = Math.max(0.0, overlapWidth / rangeWidth);
        return fraction;
    }
}

