/*
 * Decompiled with CFR 0.152.
 */
package org.epics.util.stats;

import java.time.Duration;
import java.time.Instant;

public class TimeInterval {
    private final Instant start;
    private final Instant end;

    private TimeInterval(Instant start, Instant end) {
        this.start = start;
        this.end = end;
    }

    public boolean contains(Instant instant) {
        return !(this.start != null && this.start.compareTo(instant) > 0 || this.end != null && this.end.compareTo(instant) < 0);
    }

    public static TimeInterval between(Instant start, Instant end) {
        return new TimeInterval(start, end);
    }

    public TimeInterval minus(Duration duration) {
        return TimeInterval.between(this.start.minus(duration), this.end.minus(duration));
    }

    public Instant getStart() {
        return this.start;
    }

    public Instant getEnd() {
        return this.end;
    }

    public String toString() {
        return String.valueOf(this.start) + " - " + String.valueOf(this.end);
    }

    public boolean equals(Object obj) {
        if (obj instanceof TimeInterval) {
            TimeInterval other = (TimeInterval)obj;
            boolean startEqual = this.getStart() == other.getStart() || this.getStart() != null && this.getStart().equals(other.getStart());
            boolean endEqual = this.getEnd() == other.getEnd() || this.getEnd() != null && this.getEnd().equals(other.getEnd());
            return startEqual && endEqual;
        }
        return false;
    }

    public int hashCode() {
        int hash = 5;
        hash = 29 * hash + (this.start != null ? this.start.hashCode() : 0);
        hash = 29 * hash + (this.end != null ? this.end.hashCode() : 0);
        return hash;
    }
}

