/*
 * Decompiled with CFR 0.152.
 */
package org.epics.util.array;

import java.io.Serializable;
import org.epics.util.array.CollectionNumber;
import org.epics.util.array.CollectionNumbers;
import org.epics.util.array.IteratorUByte;
import org.epics.util.array.ListNumber;
import org.epics.util.array.ListUByte;

public final class ArrayUByte
extends ListUByte
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final byte[] array;
    private final int startIndex;
    private final int size;
    private final boolean checkBoundaries;
    private final boolean readOnly;

    public ArrayUByte(CollectionNumber coll) {
        this(coll.toArray(new byte[coll.size()]), 0, coll.size(), false);
    }

    ArrayUByte(byte[] array, int startIndex, int size, boolean readOnly) {
        if (startIndex < 0 || startIndex + size > array.length) {
            throw new IndexOutOfBoundsException("Start index: " + startIndex + ", Size: " + size + ", Array length: " + array.length);
        }
        this.array = array;
        this.readOnly = readOnly;
        this.startIndex = startIndex;
        this.size = size;
        this.checkBoundaries = startIndex != 0 || size != array.length;
    }

    @Override
    public final IteratorUByte iterator() {
        return new IteratorUByte(){
            private int index;
            {
                this.index = ArrayUByte.this.startIndex;
            }

            @Override
            public boolean hasNext() {
                return this.index < ArrayUByte.this.startIndex + ArrayUByte.this.size;
            }

            @Override
            public byte nextByte() {
                return ArrayUByte.this.array[this.index++];
            }
        };
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public final byte getByte(int index) {
        if (this.checkBoundaries && (index < 0 || index >= this.size)) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        return this.array[index];
    }

    @Override
    public void setByte(int index, byte value) {
        if (!this.readOnly) {
            if (this.checkBoundaries && (index < 0 || index >= this.size)) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
            }
        } else {
            throw new UnsupportedOperationException("Read only list.");
        }
        this.array[this.startIndex + index] = value;
    }

    @Override
    public ArrayUByte subList(int fromIndex, int toIndex) {
        return new ArrayUByte(this.array, fromIndex + this.startIndex, toIndex - fromIndex, this.readOnly);
    }

    @Override
    public void setAll(int index, ListNumber list) {
        if (list instanceof ArrayUByte) {
            if (this.readOnly) {
                throw new UnsupportedOperationException("Read only list.");
            }
            ArrayUByte other = (ArrayUByte)list;
            System.arraycopy(other.array, other.startIndex, this.array, this.startIndex + index, other.size);
        } else {
            super.setAll(index, list);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ArrayUByte) {
            ArrayUByte other = (ArrayUByte)obj;
            if (this.array == other.array && this.startIndex == other.startIndex && this.size == other.size) {
                return true;
            }
        }
        return super.equals(obj);
    }

    @Override
    public <T> T toArray(T array) {
        if (array instanceof byte[]) {
            byte[] byteArray = ((byte[])array).length < this.size() ? new byte[this.size()] : (byte[])array;
            System.arraycopy(this.array, this.startIndex, byteArray, 0, this.size);
            return (T)byteArray;
        }
        return super.toArray(array);
    }

    byte[] wrappedArray() {
        return this.array;
    }

    int startIndex() {
        return this.startIndex;
    }

    boolean isReadOnly() {
        return this.readOnly;
    }

    public static ArrayUByte of(byte ... values) {
        return CollectionNumbers.unmodifiableListUByte(values);
    }
}

