/*
 * Decompiled with CFR 0.152.
 */
package org.epics.util.array;

import java.util.Arrays;
import java.util.List;
import org.epics.util.array.CollectionNumbers;
import org.epics.util.array.ListDouble;
import org.epics.util.array.ListNumber;

public class ListMath {
    private ListMath() {
    }

    public static ListDouble rescale(final ListNumber data, final double factor, final double offset) {
        if (factor == 1.0) {
            return ListMath.add(data, offset);
        }
        return new ListDouble(){

            @Override
            public double getDouble(int index) {
                return factor * data.getDouble(index) + offset;
            }

            @Override
            public int size() {
                return data.size();
            }
        };
    }

    public static ListDouble inverseRescale(final ListNumber data, final double numerator, final double offset) {
        return new ListDouble(){

            @Override
            public double getDouble(int index) {
                return numerator / data.getDouble(index) + offset;
            }

            @Override
            public int size() {
                return data.size();
            }
        };
    }

    public static ListDouble pow(final ListNumber data, final double expon) {
        return new ListDouble(){

            @Override
            public double getDouble(int index) {
                return Math.pow(data.getDouble(index), expon);
            }

            @Override
            public int size() {
                return data.size();
            }
        };
    }

    public static ListDouble pow(final double base, final ListNumber expons) {
        return new ListDouble(){

            @Override
            public double getDouble(int index) {
                return Math.pow(base, expons.getDouble(index));
            }

            @Override
            public int size() {
                return expons.size();
            }
        };
    }

    public static ListDouble add(final ListNumber data, final double offset) {
        return new ListDouble(){

            @Override
            public double getDouble(int index) {
                return data.getDouble(index) + offset;
            }

            @Override
            public int size() {
                return data.size();
            }
        };
    }

    public static ListDouble add(final ListNumber data1, final ListNumber data2) {
        if (data1.size() != data2.size()) {
            throw new IllegalArgumentException("Can't sum ListNumbers of different size (" + data1.size() + " - " + data2.size() + ")");
        }
        return new ListDouble(){

            @Override
            public double getDouble(int index) {
                return data1.getDouble(index) + data2.getDouble(index);
            }

            @Override
            public int size() {
                return data1.size();
            }
        };
    }

    public static ListDouble subtract(final ListNumber data1, final ListNumber data2) {
        if (data1.size() != data2.size()) {
            throw new IllegalArgumentException("Can't subtract ListNumbers of different size (" + data1.size() + " - " + data2.size() + ")");
        }
        return new ListDouble(){

            @Override
            public double getDouble(int index) {
                return data1.getDouble(index) - data2.getDouble(index);
            }

            @Override
            public int size() {
                return data1.size();
            }
        };
    }

    public static ListDouble multiply(final ListNumber data1, final ListNumber data2) {
        if (data1.size() != data2.size()) {
            throw new IllegalArgumentException("Can't do element-wise mult on ListNumbers of different size (" + data1.size() + " - " + data2.size() + ")");
        }
        return new ListDouble(){

            @Override
            public double getDouble(int index) {
                return data1.getDouble(index) * data2.getDouble(index);
            }

            @Override
            public int size() {
                return data1.size();
            }
        };
    }

    public static ListDouble divide(final ListNumber data1, final ListNumber data2) {
        if (data1.size() != data2.size()) {
            throw new IllegalArgumentException("Can't do element-wise mult on ListNumbers of different size (" + data1.size() + " - " + data2.size() + ")");
        }
        return new ListDouble(){

            @Override
            public double getDouble(int index) {
                return data1.getDouble(index) / data2.getDouble(index);
            }

            @Override
            public int size() {
                return data1.size();
            }
        };
    }

    public static List<ListNumber> dft(ListNumber x, ListNumber y) {
        int i;
        if (x.size() != y.size()) {
            throw new IllegalArgumentException("Real and imaginary part must be of the same length");
        }
        double[] resX = new double[x.size()];
        double[] resY = new double[x.size()];
        int direction = 1;
        double size = x.size();
        for (i = 0; i < x.size(); ++i) {
            double arg = (double)(-direction) * 2.0 * Math.PI * (double)i / size;
            for (int k = 0; k < x.size(); ++k) {
                double cosarg = Math.cos((double)k * arg);
                double sinarg = Math.sin((double)k * arg);
                int n = i;
                resX[n] = resX[n] + (x.getDouble(k) * cosarg - y.getDouble(k) * sinarg);
                int n2 = i;
                resY[n2] = resY[n2] + (x.getDouble(k) * sinarg + y.getDouble(k) * cosarg);
            }
        }
        if (direction == 1) {
            for (i = 0; i < x.size(); ++i) {
                resX[i] = resX[i] / size;
                resY[i] = resY[i] / size;
            }
            return Arrays.asList(CollectionNumbers.unmodifiableList(CollectionNumbers.toListDouble(resX)), CollectionNumbers.unmodifiableList(CollectionNumbers.toListDouble(resY)));
        }
        return Arrays.asList(CollectionNumbers.unmodifiableList(CollectionNumbers.toListDouble(resY)), CollectionNumbers.unmodifiableList(CollectionNumbers.toListDouble(resX)));
    }
}

