/*
 * Decompiled with CFR 0.152.
 */
package org.epics.util.concurrent;

import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;

public class Executors {
    private static final Logger log = Logger.getLogger(Executors.class.getName());
    private static final Executor SWING_EXECUTOR = new Executor(){

        @Override
        public void execute(Runnable command) {
            SwingUtilities.invokeLater(command);
        }
    };
    private static final Executor CURRENT_EXECUTOR = new Executor(){

        @Override
        public void execute(Runnable command) {
            try {
                command.run();
            }
            catch (Exception ex) {
                log.log(Level.WARNING, "Exception on the timer thread caused by a ValueListener", ex);
            }
            catch (AssertionError ex) {
                log.log(Level.WARNING, "Assertion failed on the timer thread", (Throwable)((Object)ex));
            }
        }
    };

    public static Executor swingEDT() {
        return SWING_EXECUTOR;
    }

    public static Executor localThread() {
        return CURRENT_EXECUTOR;
    }

    public static ThreadFactory namedPool(String poolName) {
        return new DefaultThreadFactory(poolName);
    }

    static class DefaultThreadFactory
    implements ThreadFactory {
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;

        DefaultThreadFactory(String poolName) {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = poolName;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (!t.isDaemon()) {
                t.setDaemon(true);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

