/*
 * Decompiled with CFR 0.152.
 */
package org.epics.util.number;

import org.epics.util.number.UnsignedConversions;

public final class UByte
extends Number {
    private final byte unsignedValue;

    public UByte(byte unsignedValue) {
        this.unsignedValue = unsignedValue;
    }

    @Override
    public int intValue() {
        return UnsignedConversions.toInt(this.unsignedValue);
    }

    @Override
    public long longValue() {
        return UnsignedConversions.toLong(this.unsignedValue);
    }

    @Override
    public float floatValue() {
        return UnsignedConversions.toFloat(this.unsignedValue);
    }

    @Override
    public double doubleValue() {
        return UnsignedConversions.toDouble(this.unsignedValue);
    }

    public static UByte valueOf(byte unsignedValue) {
        return new UByte(unsignedValue);
    }

    public static String toString(byte unsignedValue) {
        return Integer.toString(UnsignedConversions.toInt(unsignedValue), 10);
    }

    public boolean equals(Object obj) {
        if (obj instanceof UByte) {
            return this.unsignedValue == ((UByte)obj).unsignedValue;
        }
        return false;
    }

    public int hashCode() {
        return Byte.hashCode(this.unsignedValue);
    }

    public String toString() {
        return UByte.toString(this.unsignedValue);
    }
}

