/*
 * Decompiled with CFR 0.152.
 */
package org.epics.util.stats;

import java.util.Iterator;
import java.util.List;
import org.epics.util.array.CollectionNumber;
import org.epics.util.array.IteratorNumber;
import org.epics.util.stats.Range;
import org.epics.util.stats.Statistics;

public class StatisticsUtil {
    public static Statistics statisticsOf(CollectionNumber data) {
        IteratorNumber iterator = data.iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        int count = 0;
        double min = iterator.nextDouble();
        while (Double.isNaN(min)) {
            if (!iterator.hasNext()) {
                return null;
            }
            min = iterator.nextDouble();
        }
        double max = min;
        double total = min;
        double totalSquare = min * min;
        ++count;
        while (iterator.hasNext()) {
            double value = iterator.nextDouble();
            if (Double.isNaN(value)) continue;
            if (value > max) {
                max = value;
            }
            if (value < min) {
                min = value;
            }
            total += value;
            totalSquare += value * value;
            ++count;
        }
        double average = total / (double)count;
        double stdDev = Math.sqrt(totalSquare / (double)count - average * average);
        return new StatisticsImpl(Range.of(min, max), count, average, stdDev);
    }

    public static Statistics statisticsOf(List<Statistics> data) {
        if (data.isEmpty()) {
            return null;
        }
        Iterator<Statistics> iterator = data.iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        Statistics first = null;
        while (first == null && iterator.hasNext()) {
            first = iterator.next();
        }
        if (first == null) {
            return null;
        }
        int count = first.getCount();
        Range range = first.getRange();
        double total = first.getAverage() * (double)first.getCount();
        double totalSquare = (first.getStdDev() * first.getStdDev() + first.getAverage() * first.getAverage()) * (double)first.getCount();
        while (iterator.hasNext()) {
            Statistics stats = iterator.next();
            range = range.combine(stats.getRange());
            total += stats.getAverage() * (double)stats.getCount();
            totalSquare += (stats.getStdDev() * stats.getStdDev() + stats.getAverage() * stats.getAverage()) * (double)stats.getCount();
            count += stats.getCount();
        }
        double average = total / (double)count;
        double stdDev = Math.sqrt(totalSquare / (double)count - average * average);
        return new StatisticsImpl(range, count, average, stdDev);
    }

    public static Statistics lazyStatisticsOf(CollectionNumber data) {
        return new LazyStatistics(data);
    }

    private static class LazyStatistics
    extends Statistics {
        private Statistics stats;
        private CollectionNumber data;

        public LazyStatistics(CollectionNumber data) {
            this.data = data;
        }

        private void calculateStats() {
            if (this.stats == null) {
                this.stats = StatisticsUtil.statisticsOf(this.data);
                this.data = null;
            }
        }

        @Override
        public int getCount() {
            this.calculateStats();
            return this.stats.getCount();
        }

        @Override
        public double getAverage() {
            this.calculateStats();
            return this.stats.getAverage();
        }

        @Override
        public double getStdDev() {
            this.calculateStats();
            return this.stats.getStdDev();
        }

        @Override
        public Range getRange() {
            this.calculateStats();
            return this.stats.getRange();
        }
    }

    private static class StatisticsImpl
    extends Statistics {
        private final int count;
        private final Range range;
        private final double average;
        private final double stdDev;

        public StatisticsImpl(Range range, int count, double average, double stdDev) {
            this.count = count;
            this.range = range;
            this.average = average;
            this.stdDev = stdDev;
        }

        @Override
        public int getCount() {
            return this.count;
        }

        @Override
        public Range getRange() {
            return this.range;
        }

        @Override
        public double getAverage() {
            return this.average;
        }

        @Override
        public double getStdDev() {
            return this.stdDev;
        }
    }
}

