/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.epics.caj.cas;

import gov.aps.jca.cas.ProcessVariable;
import gov.aps.jca.cas.ProcessVariableEventCallback;
import gov.aps.jca.dbr.DBR;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ProcessVariableEventDispatcher
implements ProcessVariableEventCallback {
    private static final Logger logger = Logger.getLogger(ProcessVariableEventDispatcher.class.getName());
    protected ProcessVariable processVariable;
    private static final ProcessVariableEventCallback[] EMPTY_LIST = new ProcessVariableEventCallback[0];
    protected ArrayList listeners = new ArrayList();
    protected ProcessVariableEventCallback[] cachedList = EMPTY_LIST;

    public ProcessVariableEventDispatcher(ProcessVariable processVariable) {
        this.processVariable = processVariable;
    }

    public ProcessVariable getProcessVariable() {
        return this.processVariable;
    }

    public void setProcessVariable(ProcessVariable processVariable) {
        if (this.processVariable != null) {
            throw new IllegalStateException("PV already set");
        }
        this.processVariable = processVariable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void postEvent(int select, DBR event) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            int size = this.cachedList.length;
            for (int i = 0; i < size; ++i) {
                try {
                    this.cachedList[i].postEvent(select, event);
                    continue;
                }
                catch (Throwable th) {
                    logger.log(Level.SEVERE, "", th);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerEventListener(ProcessVariableEventCallback listener) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.add(listener);
            ProcessVariableEventCallback[] ncl = new ProcessVariableEventCallback[this.listeners.size()];
            this.listeners.toArray(ncl);
            this.cachedList = ncl;
            if (this.listeners.size() == 1 && this.processVariable != null) {
                this.processVariable.interestRegister();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterEventListener(ProcessVariableEventCallback listener) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            boolean removed = this.listeners.remove(listener);
            if (removed) {
                ProcessVariableEventCallback[] ncl = new ProcessVariableEventCallback[this.listeners.size()];
                this.listeners.toArray(ncl);
                this.cachedList = ncl;
                if (this.listeners.size() == 0 && this.processVariable != null) {
                    this.processVariable.interestDelete();
                }
            }
        }
    }

    @Override
    public void canceled() {
    }
}

