/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.epics.caj.cas.handlers;

import com.cosylab.epics.caj.cas.CAJServerContext;
import com.cosylab.epics.caj.cas.requests.ExceptionRequest;
import com.cosylab.epics.caj.impl.Transport;
import com.cosylab.epics.caj.impl.handlers.AbstractCAResponseHandler;
import gov.aps.jca.CAStatus;
import gov.aps.jca.cas.ProcessVariable;
import gov.aps.jca.dbr.DBR;
import gov.aps.jca.dbr.DBRFactory;
import gov.aps.jca.dbr.DBRType;
import gov.aps.jca.dbr.DBR_PRECISION_Double;
import gov.aps.jca.dbr.DBR_PRECISION_Float;
import gov.aps.jca.dbr.DBR_TIME_LABELS_Enum;
import gov.aps.jca.dbr.PRECISION;
import gov.aps.jca.dbr.STS;
import gov.aps.jca.dbr.Severity;
import gov.aps.jca.dbr.Status;
import java.nio.ByteBuffer;
import java.util.logging.Level;

public abstract class AbstractCASResponseHandler
extends AbstractCAResponseHandler {
    protected CAJServerContext context;
    private static final int DBR_TIME_OFFSET = 14;
    private static final int DBR_GR_OFFSET = 21;
    private static final int DBR_CTRL_OFFSET = 28;

    public AbstractCASResponseHandler(CAJServerContext context, String description) {
        super(description);
        this.context = context;
    }

    public static final String extractString(ByteBuffer buffer, int start, int maxSize, boolean setToEnd) {
        int end;
        if (start < 0) {
            start = buffer.position();
        }
        int bufferEnd = start + maxSize;
        byte[] data = buffer.array();
        for (end = start; data[end] != 0 && end < bufferEnd; ++end) {
        }
        if (setToEnd && end != bufferEnd) {
            buffer.position(end + 1);
        }
        return new String(data, start, end - start);
    }

    protected void sendException(Transport transport, int cid, CAStatus errorStatus, ByteBuffer previousHeader, String message) {
        try {
            previousHeader.flip();
            new ExceptionRequest(transport, cid, errorStatus, previousHeader, message).submit();
        }
        catch (Throwable th) {
            this.context.getLogger().log(Level.WARNING, "Failed to send exception response for CID: " + cid, th);
        }
    }

    public static final DBR createDBRforReading(ProcessVariable processVariable) {
        return AbstractCASResponseHandler.createDBRforReading(processVariable, processVariable.getDimensionSize(0));
    }

    public static final DBR createDBRforReading(ProcessVariable processVariable, int dataCount) {
        return AbstractCASResponseHandler.createDBRforReading(processVariable, (short)28, dataCount);
    }

    public static final DBR createDBRforReading(ProcessVariable processVariable, short dataType, int dataCount) {
        DBR value;
        DBRType type;
        int typeValue;
        int offset = 14;
        if (dataType >= 21) {
            int n = offset = dataType >= 28 ? 28 : 21;
        }
        if ((typeValue = (type = processVariable.getType()).getValue() + offset) == 20) {
            value = new DBR_PRECISION_Double(dataCount);
        } else if (typeValue == 16) {
            value = new DBR_PRECISION_Float(dataCount);
        } else if (typeValue == 17 || typeValue == 24 || typeValue == 31) {
            value = new DBR_TIME_LABELS_Enum(dataCount);
        } else {
            type = DBRType.forValue(typeValue);
            value = DBRFactory.create(type, dataCount);
        }
        STS dbrSts = (STS)((Object)value);
        dbrSts.setSeverity(Severity.INVALID_ALARM);
        dbrSts.setStatus(Status.UDF_ALARM);
        if (value.isPRECSION()) {
            ((PRECISION)((Object)value)).setPrecision((short)-1);
        }
        return value;
    }
}

