/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.epics.caj.cas.util;

import com.cosylab.epics.caj.cas.util.MemoryProcessVariable;
import gov.aps.jca.CAException;
import gov.aps.jca.CAStatus;
import gov.aps.jca.CAStatusException;
import gov.aps.jca.cas.ProcessVariable;
import gov.aps.jca.cas.ProcessVariableAttachCallback;
import gov.aps.jca.cas.ProcessVariableEventCallback;
import gov.aps.jca.cas.ProcessVariableExistanceCallback;
import gov.aps.jca.cas.ProcessVariableExistanceCompletion;
import gov.aps.jca.cas.Server;
import gov.aps.jca.dbr.DBRType;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;

public class DefaultServerImpl
implements Server {
    protected Map pvs = new HashMap();

    public MemoryProcessVariable createMemoryProcessVariable(String name, DBRType type, Object initialValue) {
        MemoryProcessVariable memoryProcessVariable = new MemoryProcessVariable(name, null, type, initialValue);
        this.registerProcessVaribale(name, memoryProcessVariable);
        return memoryProcessVariable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerProcessVaribale(String aliasName, ProcessVariable pv) {
        Map map = this.pvs;
        synchronized (map) {
            this.pvs.put(aliasName, pv);
        }
    }

    public void registerProcessVaribale(ProcessVariable pv) {
        this.registerProcessVaribale(pv.getName(), pv);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessVariable unregisterProcessVaribale(String aliasName) {
        Map map = this.pvs;
        synchronized (map) {
            return (ProcessVariable)this.pvs.remove(aliasName);
        }
    }

    @Override
    public ProcessVariable processVariableAttach(String aliasName, ProcessVariableEventCallback eventCallback, ProcessVariableAttachCallback asyncCompletionCallback) throws CAStatusException, IllegalArgumentException, IllegalStateException {
        Map map = this.pvs;
        synchronized (map) {
            ProcessVariable pv = (ProcessVariable)this.pvs.get(aliasName);
            if (pv != null) {
                if (pv.getEventCallback() == null) {
                    pv.setEventCallback(eventCallback);
                }
                return pv;
            }
            throw new CAStatusException(CAStatus.NOSUPPORT, "PV does not exist");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProcessVariableExistanceCompletion processVariableExistanceTest(String aliasName, InetSocketAddress clientAddress, ProcessVariableExistanceCallback asyncCompletionCallback) throws CAException, IllegalArgumentException, IllegalStateException {
        Map map = this.pvs;
        synchronized (map) {
            return this.pvs.containsKey(aliasName) ? ProcessVariableExistanceCompletion.EXISTS_HERE : ProcessVariableExistanceCompletion.DOES_NOT_EXIST_HERE;
        }
    }
}

