/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.epics.caj.impl;

import com.cosylab.epics.caj.CAJContext;
import com.cosylab.epics.caj.impl.CATransport;
import com.cosylab.epics.caj.impl.Transport;
import java.net.InetSocketAddress;

public class CABeaconHandler {
    private CAJContext context;
    private InetSocketAddress responseFrom;
    private long averagePeriod = Long.MIN_VALUE;
    private boolean periodStabilized = false;
    private long lastBeaconSequenceID;
    private long lastBeaconTimeStamp = Long.MIN_VALUE;
    private final long initializationTimeStamp = System.currentTimeMillis();

    public CABeaconHandler(CAJContext context, InetSocketAddress responseFrom) {
        this.context = context;
        this.responseFrom = responseFrom;
    }

    public void beaconNotify(short remoteTransportRevision, long timestamp, long sequentalID) {
        boolean networkChanged = this.updateBeaconPeriod(remoteTransportRevision, timestamp, sequentalID);
        if (networkChanged) {
            this.changedTransport();
        }
    }

    private synchronized boolean updateBeaconPeriod(short remoteTransportRevision, long timestamp, long sequentalID) {
        if (this.lastBeaconTimeStamp == Long.MIN_VALUE) {
            this.context.beaconAnomalyNotify();
            if (remoteTransportRevision >= 10) {
                this.lastBeaconSequenceID = sequentalID;
            }
            this.lastBeaconTimeStamp = timestamp;
            this.beaconArrivalNotify();
            return false;
        }
        if (remoteTransportRevision >= 10) {
            long beaconSeqAdvance = sequentalID >= this.lastBeaconSequenceID ? sequentalID - this.lastBeaconSequenceID : 0xFFFFFFFFL - this.lastBeaconSequenceID + sequentalID;
            this.lastBeaconSequenceID = sequentalID;
            if (beaconSeqAdvance == 0L || beaconSeqAdvance > 0xFFFFFEFFL) {
                return false;
            }
            if (beaconSeqAdvance > 1L && beaconSeqAdvance < 4L) {
                return false;
            }
        }
        boolean networkChange = false;
        long currentPeriod = timestamp - this.lastBeaconTimeStamp;
        if (this.averagePeriod < 0L) {
            this.averagePeriod = currentPeriod;
            this.beaconArrivalNotify();
        } else {
            if ((double)currentPeriod >= (double)this.averagePeriod * 1.25) {
                if ((double)currentPeriod >= (double)this.averagePeriod * 3.25) {
                    this.context.beaconAnomalyNotify();
                    networkChange = true;
                } else if (!this.periodStabilized) {
                    this.averagePeriod = currentPeriod;
                    this.beaconArrivalNotify();
                } else {
                    this.context.beaconAnomalyNotify();
                }
            } else if ((double)currentPeriod <= (double)this.averagePeriod * 0.8) {
                this.context.beaconAnomalyNotify();
                networkChange = true;
            } else {
                this.periodStabilized = true;
                this.beaconArrivalNotify();
            }
            if (networkChange) {
                this.periodStabilized = false;
                this.averagePeriod = -1L;
            } else {
                this.averagePeriod = (long)((double)currentPeriod * 0.125 + (double)this.averagePeriod * 0.875);
            }
        }
        this.lastBeaconTimeStamp = timestamp;
        return networkChange;
    }

    private void beaconArrivalNotify() {
        Transport[] transports = this.context.getTransportRegistry().get(this.responseFrom);
        if (transports == null) {
            return;
        }
        for (int i = 0; i < transports.length; ++i) {
            ((CATransport)transports[i]).beaconArrivalNotify();
        }
    }

    private void changedTransport() {
        Transport[] transports = this.context.getTransportRegistry().get(this.responseFrom);
        if (transports == null) {
            return;
        }
        for (int i = 0; i < transports.length; ++i) {
            ((CATransport)transports[i]).changedTransport();
        }
    }
}

