/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.epics.caj.impl;

import gov.aps.jca.dbr.CTRL;
import gov.aps.jca.dbr.DBR;
import gov.aps.jca.dbr.DBRType;
import gov.aps.jca.dbr.DBR_Byte;
import gov.aps.jca.dbr.DBR_CTRL_Byte;
import gov.aps.jca.dbr.DBR_CTRL_Double;
import gov.aps.jca.dbr.DBR_CTRL_Enum;
import gov.aps.jca.dbr.DBR_CTRL_Float;
import gov.aps.jca.dbr.DBR_CTRL_Int;
import gov.aps.jca.dbr.DBR_CTRL_Short;
import gov.aps.jca.dbr.DBR_CTRL_String;
import gov.aps.jca.dbr.DBR_Double;
import gov.aps.jca.dbr.DBR_Enum;
import gov.aps.jca.dbr.DBR_Float;
import gov.aps.jca.dbr.DBR_GR_Byte;
import gov.aps.jca.dbr.DBR_GR_Double;
import gov.aps.jca.dbr.DBR_GR_Float;
import gov.aps.jca.dbr.DBR_GR_Int;
import gov.aps.jca.dbr.DBR_GR_Short;
import gov.aps.jca.dbr.DBR_GR_String;
import gov.aps.jca.dbr.DBR_Int;
import gov.aps.jca.dbr.DBR_LABELS_Enum;
import gov.aps.jca.dbr.DBR_PutAckS;
import gov.aps.jca.dbr.DBR_PutAckT;
import gov.aps.jca.dbr.DBR_STSACK_String;
import gov.aps.jca.dbr.DBR_STS_Byte;
import gov.aps.jca.dbr.DBR_STS_Double;
import gov.aps.jca.dbr.DBR_STS_Enum;
import gov.aps.jca.dbr.DBR_STS_Float;
import gov.aps.jca.dbr.DBR_STS_Int;
import gov.aps.jca.dbr.DBR_STS_Short;
import gov.aps.jca.dbr.DBR_STS_String;
import gov.aps.jca.dbr.DBR_Short;
import gov.aps.jca.dbr.DBR_String;
import gov.aps.jca.dbr.DBR_TIME_Byte;
import gov.aps.jca.dbr.DBR_TIME_Double;
import gov.aps.jca.dbr.DBR_TIME_Enum;
import gov.aps.jca.dbr.DBR_TIME_Float;
import gov.aps.jca.dbr.DBR_TIME_Int;
import gov.aps.jca.dbr.DBR_TIME_Short;
import gov.aps.jca.dbr.DBR_TIME_String;
import gov.aps.jca.dbr.GR;
import gov.aps.jca.dbr.STS;
import gov.aps.jca.dbr.TIME;
import gov.aps.jca.dbr.TimeStamp;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DBRDecoder {
    private static final int OPTIMIZED_COPY_THRESHOLD = 10;
    private static final Logger logger = Logger.getLogger(DBRDecoder.class.getName());

    public static DBR getDBR(DBR inDBR, short dataTypeValue, int dataCount, ByteBuffer dataPayloadBuffer) {
        try {
            DBRType dataType = DBRType.forValue(dataTypeValue);
            if (dataType == null) {
                throw new IllegalArgumentException("Invalid data type.");
            }
            if (inDBR != null && (inDBR.getType() != dataType || inDBR.getCount() != dataCount)) {
                throw new IllegalArgumentException("Encoded DBR and expected DBR are not consistant.");
            }
            if (dataTypeValue < DBR_String.TYPE.getValue()) {
                return null;
            }
            if (dataTypeValue < DBR_STS_String.TYPE.getValue()) {
                return DBRDecoder.getValueDBR(inDBR, dataType, dataCount, dataPayloadBuffer);
            }
            if (dataTypeValue < DBR_TIME_String.TYPE.getValue()) {
                return DBRDecoder.getStatusDBR(inDBR, dataType, dataCount, dataPayloadBuffer);
            }
            if (dataTypeValue < DBR_GR_Short.TYPE.getValue() - 1) {
                return DBRDecoder.getTimeDBR(inDBR, dataType, dataCount, dataPayloadBuffer);
            }
            if (dataTypeValue < DBR_CTRL_Short.TYPE.getValue() - 1) {
                return DBRDecoder.getGraphicsDBR(inDBR, dataType, dataCount, dataPayloadBuffer);
            }
            if (dataTypeValue < DBR_PutAckT.TYPE.getValue()) {
                return DBRDecoder.getControlDBR(inDBR, dataType, dataCount, dataPayloadBuffer);
            }
            if (dataType == DBR_PutAckT.TYPE) {
                return DBRDecoder.getAckTDBR(inDBR, dataCount, dataPayloadBuffer);
            }
            if (dataType == DBR_PutAckS.TYPE) {
                return DBRDecoder.getAckSDBR(inDBR, dataCount, dataPayloadBuffer);
            }
            if (dataType == DBR_STSACK_String.TYPE) {
                return DBRDecoder.getStatusAckStringDBR(inDBR, dataCount, dataPayloadBuffer);
            }
            return null;
        }
        catch (Throwable th) {
            logger.log(Level.SEVERE, "", th);
            return null;
        }
    }

    private static DBR getValueDBR(DBR inDBR, DBRType dataType, int dataCount, ByteBuffer dataPayloadBuffer) {
        DBR retVal = inDBR;
        if (dataType == DBR_String.TYPE) {
            if (retVal == null) {
                retVal = new DBR_String((String[])DBRDecoder.readValues(null, DBR_String.TYPE, dataCount, dataPayloadBuffer));
            } else {
                DBRDecoder.readValues(retVal, DBR_String.TYPE, dataCount, dataPayloadBuffer);
            }
        } else if (dataType == DBR_Short.TYPE) {
            if (retVal == null) {
                retVal = new DBR_Short((short[])DBRDecoder.readValues(null, DBR_Short.TYPE, dataCount, dataPayloadBuffer));
            } else {
                DBRDecoder.readValues(retVal, DBR_Short.TYPE, dataCount, dataPayloadBuffer);
            }
        } else if (dataType == DBR_Float.TYPE) {
            if (retVal == null) {
                retVal = new DBR_Float((float[])DBRDecoder.readValues(null, DBR_Float.TYPE, dataCount, dataPayloadBuffer));
            } else {
                DBRDecoder.readValues(retVal, DBR_Float.TYPE, dataCount, dataPayloadBuffer);
            }
        } else if (dataType == DBR_Enum.TYPE) {
            if (retVal == null) {
                retVal = new DBR_Enum((short[])DBRDecoder.readValues(null, DBR_Enum.TYPE, dataCount, dataPayloadBuffer));
            } else {
                DBRDecoder.readValues(retVal, DBR_Enum.TYPE, dataCount, dataPayloadBuffer);
            }
        } else if (dataType == DBR_Byte.TYPE) {
            if (retVal == null) {
                retVal = new DBR_Byte((byte[])DBRDecoder.readValues(null, DBR_Byte.TYPE, dataCount, dataPayloadBuffer));
            } else {
                DBRDecoder.readValues(retVal, DBR_Byte.TYPE, dataCount, dataPayloadBuffer);
            }
        } else if (dataType == DBR_Int.TYPE) {
            if (retVal == null) {
                retVal = new DBR_Int((int[])DBRDecoder.readValues(null, DBR_Int.TYPE, dataCount, dataPayloadBuffer));
            } else {
                DBRDecoder.readValues(retVal, DBR_Int.TYPE, dataCount, dataPayloadBuffer);
            }
        } else if (dataType == DBR_Double.TYPE) {
            if (retVal == null) {
                retVal = new DBR_Double((double[])DBRDecoder.readValues(null, DBR_Double.TYPE, dataCount, dataPayloadBuffer));
            } else {
                DBRDecoder.readValues(retVal, DBR_Double.TYPE, dataCount, dataPayloadBuffer);
            }
        }
        return retVal;
    }

    private static Object readValues(DBR inDBR, DBRType dataType, int dataCount, ByteBuffer dataPayloadBuffer) {
        if (dataType == DBR_String.TYPE) {
            String[] arr = inDBR != null ? (String[])inDBR.getValue() : new String[dataCount];
            if (dataCount == 1) {
                int end;
                int start = dataPayloadBuffer.position();
                int bufferEnd = dataPayloadBuffer.limit();
                for (end = start; dataPayloadBuffer.get(end) != 0 && end < bufferEnd; ++end) {
                }
                if (dataPayloadBuffer.hasArray()) {
                    arr[0] = new String(dataPayloadBuffer.array(), start, end - start);
                } else {
                    int length = end - start;
                    byte[] data = new byte[length];
                    if (length < 10) {
                        for (int i = 0; i < length; ++i) {
                            data[i] = dataPayloadBuffer.get();
                        }
                    } else {
                        dataPayloadBuffer.get(data, 0, length);
                    }
                    arr[0] = new String(data, 0, length);
                }
            } else {
                byte[] rawBuffer = new byte[40];
                for (int i = 0; i < dataCount; ++i) {
                    dataPayloadBuffer.get(rawBuffer);
                    arr[i] = DBRDecoder.extractString(rawBuffer);
                }
            }
            return arr;
        }
        if (dataType == DBR_Short.TYPE) {
            short[] arr = inDBR != null ? (short[])inDBR.getValue() : new short[dataCount];
            if (dataCount < 10) {
                for (int i = 0; i < dataCount; ++i) {
                    arr[i] = dataPayloadBuffer.getShort();
                }
            } else {
                dataPayloadBuffer.asShortBuffer().get(arr, 0, dataCount);
            }
            return arr;
        }
        if (dataType == DBR_Float.TYPE) {
            float[] arr = inDBR != null ? (float[])inDBR.getValue() : new float[dataCount];
            if (dataCount < 10) {
                for (int i = 0; i < dataCount; ++i) {
                    arr[i] = dataPayloadBuffer.getFloat();
                }
            } else {
                dataPayloadBuffer.asFloatBuffer().get(arr, 0, dataCount);
            }
            return arr;
        }
        if (dataType == DBR_Enum.TYPE) {
            short[] arr = inDBR != null ? (short[])inDBR.getValue() : new short[dataCount];
            if (dataCount < 10) {
                for (int i = 0; i < dataCount; ++i) {
                    arr[i] = dataPayloadBuffer.getShort();
                }
            } else {
                dataPayloadBuffer.asShortBuffer().get(arr, 0, dataCount);
            }
            return arr;
        }
        if (dataType == DBR_Byte.TYPE) {
            byte[] arr = inDBR != null ? (byte[])inDBR.getValue() : new byte[dataCount];
            if (dataCount < 10) {
                for (int i = 0; i < dataCount; ++i) {
                    arr[i] = dataPayloadBuffer.get();
                }
            } else {
                dataPayloadBuffer.get(arr, 0, dataCount);
            }
            return arr;
        }
        if (dataType == DBR_Int.TYPE) {
            int[] arr = inDBR != null ? (int[])inDBR.getValue() : new int[dataCount];
            if (dataCount < 10) {
                for (int i = 0; i < dataCount; ++i) {
                    arr[i] = dataPayloadBuffer.getInt();
                }
            } else {
                dataPayloadBuffer.asIntBuffer().get(arr, 0, dataCount);
            }
            return arr;
        }
        if (dataType == DBR_Double.TYPE) {
            double[] arr = inDBR != null ? (double[])inDBR.getValue() : new double[dataCount];
            if (dataCount < 10) {
                for (int i = 0; i < dataCount; ++i) {
                    arr[i] = dataPayloadBuffer.getDouble();
                }
            } else {
                dataPayloadBuffer.asDoubleBuffer().get(arr, 0, dataCount);
            }
            return arr;
        }
        return null;
    }

    private static DBR getStatusDBR(DBR inDBR, DBRType dataType, int dataCount, ByteBuffer dataPayloadBuffer) {
        STS retVal = (STS)((Object)inDBR);
        int status = dataPayloadBuffer.getShort() & 0xFFFF;
        int severity = dataPayloadBuffer.getShort() & 0xFFFF;
        if (dataType == DBR_STS_String.TYPE) {
            if (retVal == null) {
                retVal = new DBR_STS_String((String[])DBRDecoder.readValues(null, DBR_String.TYPE, dataCount, dataPayloadBuffer));
            } else {
                DBRDecoder.readValues(inDBR, DBR_String.TYPE, dataCount, dataPayloadBuffer);
            }
        } else if (dataType == DBR_GR_String.TYPE) {
            if (retVal == null) {
                retVal = new DBR_GR_String((String[])DBRDecoder.readValues(null, DBR_String.TYPE, dataCount, dataPayloadBuffer));
            } else {
                DBRDecoder.readValues(inDBR, DBR_String.TYPE, dataCount, dataPayloadBuffer);
            }
        } else if (dataType == DBR_CTRL_String.TYPE) {
            if (retVal == null) {
                retVal = new DBR_CTRL_String((String[])DBRDecoder.readValues(null, DBR_String.TYPE, dataCount, dataPayloadBuffer));
            } else {
                DBRDecoder.readValues(inDBR, DBR_String.TYPE, dataCount, dataPayloadBuffer);
            }
        } else if (dataType == DBR_STS_Short.TYPE) {
            if (retVal == null) {
                retVal = new DBR_STS_Short((short[])DBRDecoder.readValues(null, DBR_Short.TYPE, dataCount, dataPayloadBuffer));
            } else {
                DBRDecoder.readValues(inDBR, DBR_Short.TYPE, dataCount, dataPayloadBuffer);
            }
        } else if (dataType == DBR_STS_Float.TYPE) {
            if (retVal == null) {
                retVal = new DBR_STS_Float((float[])DBRDecoder.readValues(null, DBR_Float.TYPE, dataCount, dataPayloadBuffer));
            } else {
                DBRDecoder.readValues(inDBR, DBR_Float.TYPE, dataCount, dataPayloadBuffer);
            }
        } else if (dataType == DBR_STS_Enum.TYPE) {
            if (retVal == null) {
                retVal = new DBR_STS_Enum((short[])DBRDecoder.readValues(null, DBR_Enum.TYPE, dataCount, dataPayloadBuffer));
            } else {
                DBRDecoder.readValues(inDBR, DBR_Enum.TYPE, dataCount, dataPayloadBuffer);
            }
        } else if (dataType == DBR_STS_Byte.TYPE) {
            dataPayloadBuffer.get();
            if (retVal == null) {
                retVal = new DBR_STS_Byte((byte[])DBRDecoder.readValues(null, DBR_Byte.TYPE, dataCount, dataPayloadBuffer));
            } else {
                DBRDecoder.readValues(inDBR, DBR_Byte.TYPE, dataCount, dataPayloadBuffer);
            }
        } else if (dataType == DBR_STS_Int.TYPE) {
            if (retVal == null) {
                retVal = new DBR_STS_Int((int[])DBRDecoder.readValues(null, DBR_Int.TYPE, dataCount, dataPayloadBuffer));
            } else {
                DBRDecoder.readValues(inDBR, DBR_Int.TYPE, dataCount, dataPayloadBuffer);
            }
        } else if (dataType == DBR_STS_Double.TYPE) {
            dataPayloadBuffer.getInt();
            if (retVal == null) {
                retVal = new DBR_STS_Double((double[])DBRDecoder.readValues(null, DBR_Double.TYPE, dataCount, dataPayloadBuffer));
            } else {
                DBRDecoder.readValues(inDBR, DBR_Double.TYPE, dataCount, dataPayloadBuffer);
            }
        }
        retVal.setStatus(status);
        retVal.setSeverity(severity);
        return (DBR)((Object)retVal);
    }

    private static DBR getTimeDBR(DBR inDBR, DBRType dataType, int dataCount, ByteBuffer dataPayloadBuffer) {
        TIME retVal = (TIME)((Object)inDBR);
        int status = dataPayloadBuffer.getShort() & 0xFFFF;
        int severity = dataPayloadBuffer.getShort() & 0xFFFF;
        long secPastEpoch = (long)dataPayloadBuffer.getInt() & 0xFFFFFFFFL;
        long nsec = (long)dataPayloadBuffer.getInt() & 0xFFFFFFFFL;
        if (dataType == DBR_TIME_String.TYPE) {
            if (retVal == null) {
                retVal = new DBR_TIME_String((String[])DBRDecoder.readValues(null, DBR_String.TYPE, dataCount, dataPayloadBuffer));
            } else {
                DBRDecoder.readValues(inDBR, DBR_String.TYPE, dataCount, dataPayloadBuffer);
            }
        } else if (dataType == DBR_TIME_Short.TYPE) {
            dataPayloadBuffer.getShort();
            if (retVal == null) {
                retVal = new DBR_TIME_Short((short[])DBRDecoder.readValues(null, DBR_Short.TYPE, dataCount, dataPayloadBuffer));
            } else {
                DBRDecoder.readValues(inDBR, DBR_Short.TYPE, dataCount, dataPayloadBuffer);
            }
        } else if (dataType == DBR_TIME_Float.TYPE) {
            if (retVal == null) {
                retVal = new DBR_TIME_Float((float[])DBRDecoder.readValues(null, DBR_Float.TYPE, dataCount, dataPayloadBuffer));
            } else {
                DBRDecoder.readValues(inDBR, DBR_Float.TYPE, dataCount, dataPayloadBuffer);
            }
        } else if (dataType == DBR_TIME_Enum.TYPE) {
            dataPayloadBuffer.getShort();
            if (retVal == null) {
                retVal = new DBR_TIME_Enum((short[])DBRDecoder.readValues(null, DBR_Enum.TYPE, dataCount, dataPayloadBuffer));
            } else {
                DBRDecoder.readValues(inDBR, DBR_Enum.TYPE, dataCount, dataPayloadBuffer);
            }
        } else if (dataType == DBR_TIME_Byte.TYPE) {
            dataPayloadBuffer.getShort();
            dataPayloadBuffer.get();
            if (retVal == null) {
                retVal = new DBR_TIME_Byte((byte[])DBRDecoder.readValues(null, DBR_Byte.TYPE, dataCount, dataPayloadBuffer));
            } else {
                DBRDecoder.readValues(inDBR, DBR_Byte.TYPE, dataCount, dataPayloadBuffer);
            }
        } else if (dataType == DBR_TIME_Int.TYPE) {
            if (retVal == null) {
                retVal = new DBR_TIME_Int((int[])DBRDecoder.readValues(null, DBR_Int.TYPE, dataCount, dataPayloadBuffer));
            } else {
                DBRDecoder.readValues(inDBR, DBR_Int.TYPE, dataCount, dataPayloadBuffer);
            }
        } else if (dataType == DBR_TIME_Double.TYPE) {
            dataPayloadBuffer.getInt();
            if (retVal == null) {
                retVal = new DBR_TIME_Double((double[])DBRDecoder.readValues(null, DBR_Double.TYPE, dataCount, dataPayloadBuffer));
            } else {
                DBRDecoder.readValues(inDBR, DBR_Double.TYPE, dataCount, dataPayloadBuffer);
            }
        }
        retVal.setStatus(status);
        retVal.setSeverity(severity);
        retVal.setTimeStamp(new TimeStamp(secPastEpoch, nsec));
        return (DBR)((Object)retVal);
    }

    private static String extractString(byte[] rawBuffer) {
        int len;
        int rawBufferLen = rawBuffer.length;
        for (len = 0; len < rawBufferLen && rawBuffer[len] != 0; ++len) {
        }
        return new String(rawBuffer, 0, len);
    }

    private static DBR getGraphicsDBR(DBR inDBR, DBRType dataType, int dataCount, ByteBuffer dataPayloadBuffer) {
        if (dataType == DBR_GR_String.TYPE) {
            return DBRDecoder.getStatusDBR(inDBR, dataType, dataCount, dataPayloadBuffer);
        }
        int status = dataPayloadBuffer.getShort() & 0xFFFF;
        int severity = dataPayloadBuffer.getShort() & 0xFFFF;
        if (dataType == DBR_LABELS_Enum.TYPE || dataType == DBR_CTRL_Enum.TYPE) {
            int MAX_ENUM_STRING_SIZE = 26;
            int MAX_ENUM_STATES = 16;
            int count = dataPayloadBuffer.getShort() & 0xFFFF;
            byte[] rawBuffer = new byte[26];
            String[] labels = new String[count];
            for (int i = 0; i < count; ++i) {
                dataPayloadBuffer.get(rawBuffer);
                labels[i] = DBRDecoder.extractString(rawBuffer);
            }
            int restEntries = 16 - count;
            for (int i = 0; i < restEntries; ++i) {
                dataPayloadBuffer.get(rawBuffer);
            }
            DBR_LABELS_Enum le = (DBR_LABELS_Enum)inDBR;
            if (le == null) {
                le = dataType == DBR_LABELS_Enum.TYPE ? new DBR_LABELS_Enum((short[])DBRDecoder.readValues(null, DBR_Enum.TYPE, dataCount, dataPayloadBuffer)) : new DBR_CTRL_Enum((short[])DBRDecoder.readValues(null, DBR_Enum.TYPE, dataCount, dataPayloadBuffer));
            } else {
                DBRDecoder.readValues(le, DBR_Enum.TYPE, dataCount, dataPayloadBuffer);
            }
            le.setStatus(status);
            le.setSeverity(severity);
            le.setLabels(labels);
            return le;
        }
        GR retVal = (GR)((Object)inDBR);
        int precision = 0;
        if (dataType == DBR_GR_Float.TYPE || dataType == DBR_GR_Double.TYPE) {
            precision = dataPayloadBuffer.getShort() & 0xFFFF;
            dataPayloadBuffer.getShort();
        }
        int MAX_UNITS_SIZE = 8;
        byte[] rawUnits = new byte[8];
        dataPayloadBuffer.get(rawUnits);
        String units = DBRDecoder.extractString(rawUnits);
        if (dataType == DBR_GR_Short.TYPE) {
            Short upperDisplay = new Short(dataPayloadBuffer.getShort());
            Short lowerDisplay = new Short(dataPayloadBuffer.getShort());
            Short upperAlarm = new Short(dataPayloadBuffer.getShort());
            Short upperWarning = new Short(dataPayloadBuffer.getShort());
            Short lowerWarning = new Short(dataPayloadBuffer.getShort());
            Short lowerAlarm = new Short(dataPayloadBuffer.getShort());
            if (retVal == null) {
                retVal = new DBR_GR_Short((short[])DBRDecoder.readValues(null, DBR_Short.TYPE, dataCount, dataPayloadBuffer));
            } else {
                DBRDecoder.readValues(inDBR, DBR_Short.TYPE, dataCount, dataPayloadBuffer);
            }
            retVal.setUpperDispLimit(upperDisplay);
            retVal.setUpperAlarmLimit(upperAlarm);
            retVal.setUpperWarningLimit(upperWarning);
            retVal.setLowerWarningLimit(lowerWarning);
            retVal.setLowerAlarmLimit(lowerAlarm);
            retVal.setLowerDispLimit(lowerDisplay);
        } else if (dataType == DBR_GR_Float.TYPE) {
            Float upperDisplay = new Float(dataPayloadBuffer.getFloat());
            Float lowerDisplay = new Float(dataPayloadBuffer.getFloat());
            Float upperAlarm = new Float(dataPayloadBuffer.getFloat());
            Float upperWarning = new Float(dataPayloadBuffer.getFloat());
            Float lowerWarning = new Float(dataPayloadBuffer.getFloat());
            Float lowerAlarm = new Float(dataPayloadBuffer.getFloat());
            DBR_GR_Float val = (DBR_GR_Float)inDBR;
            if (val == null) {
                val = new DBR_GR_Float((float[])DBRDecoder.readValues(null, DBR_Float.TYPE, dataCount, dataPayloadBuffer));
            } else {
                DBRDecoder.readValues(val, DBR_Float.TYPE, dataCount, dataPayloadBuffer);
            }
            val.setPrecision((short)precision);
            retVal = val;
            retVal.setUpperDispLimit(upperDisplay);
            retVal.setUpperAlarmLimit(upperAlarm);
            retVal.setUpperWarningLimit(upperWarning);
            retVal.setLowerWarningLimit(lowerWarning);
            retVal.setLowerAlarmLimit(lowerAlarm);
            retVal.setLowerDispLimit(lowerDisplay);
        } else if (dataType == DBR_GR_Byte.TYPE) {
            Byte upperDisplay = new Byte(dataPayloadBuffer.get());
            Byte lowerDisplay = new Byte(dataPayloadBuffer.get());
            Byte upperAlarm = new Byte(dataPayloadBuffer.get());
            Byte upperWarning = new Byte(dataPayloadBuffer.get());
            Byte lowerWarning = new Byte(dataPayloadBuffer.get());
            Byte lowerAlarm = new Byte(dataPayloadBuffer.get());
            dataPayloadBuffer.get();
            if (retVal == null) {
                retVal = new DBR_GR_Byte((byte[])DBRDecoder.readValues(null, DBR_Byte.TYPE, dataCount, dataPayloadBuffer));
            } else {
                DBRDecoder.readValues(inDBR, DBR_Byte.TYPE, dataCount, dataPayloadBuffer);
            }
            retVal.setUpperDispLimit(upperDisplay);
            retVal.setUpperAlarmLimit(upperAlarm);
            retVal.setUpperWarningLimit(upperWarning);
            retVal.setLowerWarningLimit(lowerWarning);
            retVal.setLowerAlarmLimit(lowerAlarm);
            retVal.setLowerDispLimit(lowerDisplay);
        } else if (dataType == DBR_GR_Int.TYPE) {
            Integer upperDisplay = new Integer(dataPayloadBuffer.getInt());
            Integer lowerDisplay = new Integer(dataPayloadBuffer.getInt());
            Integer upperAlarm = new Integer(dataPayloadBuffer.getInt());
            Integer upperWarning = new Integer(dataPayloadBuffer.getInt());
            Integer lowerWarning = new Integer(dataPayloadBuffer.getInt());
            Integer lowerAlarm = new Integer(dataPayloadBuffer.getInt());
            if (retVal == null) {
                retVal = new DBR_GR_Int((int[])DBRDecoder.readValues(null, DBR_Int.TYPE, dataCount, dataPayloadBuffer));
            } else {
                DBRDecoder.readValues(inDBR, DBR_Int.TYPE, dataCount, dataPayloadBuffer);
            }
            retVal.setUpperDispLimit(upperDisplay);
            retVal.setUpperAlarmLimit(upperAlarm);
            retVal.setUpperWarningLimit(upperWarning);
            retVal.setLowerWarningLimit(lowerWarning);
            retVal.setLowerAlarmLimit(lowerAlarm);
            retVal.setLowerDispLimit(lowerDisplay);
        } else if (dataType == DBR_GR_Double.TYPE) {
            Double upperDisplay = new Double(dataPayloadBuffer.getDouble());
            Double lowerDisplay = new Double(dataPayloadBuffer.getDouble());
            Double upperAlarm = new Double(dataPayloadBuffer.getDouble());
            Double upperWarning = new Double(dataPayloadBuffer.getDouble());
            Double lowerWarning = new Double(dataPayloadBuffer.getDouble());
            Double lowerAlarm = new Double(dataPayloadBuffer.getDouble());
            DBR_GR_Double val = (DBR_GR_Double)inDBR;
            if (val == null) {
                val = new DBR_GR_Double((double[])DBRDecoder.readValues(null, DBR_Double.TYPE, dataCount, dataPayloadBuffer));
            } else {
                DBRDecoder.readValues(val, DBR_Double.TYPE, dataCount, dataPayloadBuffer);
            }
            val.setPrecision((short)precision);
            retVal = val;
            retVal.setUpperDispLimit(upperDisplay);
            retVal.setUpperAlarmLimit(upperAlarm);
            retVal.setUpperWarningLimit(upperWarning);
            retVal.setLowerWarningLimit(lowerWarning);
            retVal.setLowerAlarmLimit(lowerAlarm);
            retVal.setLowerDispLimit(lowerDisplay);
        }
        retVal.setStatus(status);
        retVal.setSeverity(severity);
        retVal.setUnits(units);
        return (DBR)((Object)retVal);
    }

    private static DBR getControlDBR(DBR inDBR, DBRType dataType, int dataCount, ByteBuffer dataPayloadBuffer) {
        if (dataType == DBR_CTRL_String.TYPE) {
            return DBRDecoder.getStatusDBR(inDBR, dataType, dataCount, dataPayloadBuffer);
        }
        if (dataType == DBR_CTRL_Enum.TYPE) {
            return DBRDecoder.getGraphicsDBR(inDBR, dataType, dataCount, dataPayloadBuffer);
        }
        int status = dataPayloadBuffer.getShort() & 0xFFFF;
        int severity = dataPayloadBuffer.getShort() & 0xFFFF;
        CTRL retVal = (CTRL)((Object)inDBR);
        int precision = 0;
        if (dataType == DBR_CTRL_Float.TYPE || dataType == DBR_CTRL_Double.TYPE) {
            precision = dataPayloadBuffer.getShort() & 0xFFFF;
            dataPayloadBuffer.getShort();
        }
        int MAX_UNITS_SIZE = 8;
        byte[] rawUnits = new byte[8];
        dataPayloadBuffer.get(rawUnits);
        String units = DBRDecoder.extractString(rawUnits);
        if (dataType == DBR_CTRL_Short.TYPE) {
            Short upperDisplay = new Short(dataPayloadBuffer.getShort());
            Short lowerDisplay = new Short(dataPayloadBuffer.getShort());
            Short upperAlarm = new Short(dataPayloadBuffer.getShort());
            Short upperWarning = new Short(dataPayloadBuffer.getShort());
            Short lowerWarning = new Short(dataPayloadBuffer.getShort());
            Short lowerAlarm = new Short(dataPayloadBuffer.getShort());
            Short upperControl = new Short(dataPayloadBuffer.getShort());
            Short lowerControl = new Short(dataPayloadBuffer.getShort());
            if (retVal == null) {
                retVal = new DBR_CTRL_Short((short[])DBRDecoder.readValues(null, DBR_Short.TYPE, dataCount, dataPayloadBuffer));
            } else {
                DBRDecoder.readValues(inDBR, DBR_Short.TYPE, dataCount, dataPayloadBuffer);
            }
            retVal.setUpperDispLimit(upperDisplay);
            retVal.setUpperAlarmLimit(upperAlarm);
            retVal.setUpperWarningLimit(upperWarning);
            retVal.setLowerWarningLimit(lowerWarning);
            retVal.setLowerAlarmLimit(lowerAlarm);
            retVal.setLowerDispLimit(lowerDisplay);
            retVal.setUpperCtrlLimit(upperControl);
            retVal.setLowerCtrlLimit(lowerControl);
        } else if (dataType == DBR_CTRL_Float.TYPE) {
            Float upperDisplay = new Float(dataPayloadBuffer.getFloat());
            Float lowerDisplay = new Float(dataPayloadBuffer.getFloat());
            Float upperAlarm = new Float(dataPayloadBuffer.getFloat());
            Float upperWarning = new Float(dataPayloadBuffer.getFloat());
            Float lowerWarning = new Float(dataPayloadBuffer.getFloat());
            Float lowerAlarm = new Float(dataPayloadBuffer.getFloat());
            Float upperControl = new Float(dataPayloadBuffer.getFloat());
            Float lowerControl = new Float(dataPayloadBuffer.getFloat());
            DBR_CTRL_Float val = (DBR_CTRL_Float)inDBR;
            if (val == null) {
                val = new DBR_CTRL_Float((float[])DBRDecoder.readValues(null, DBR_Float.TYPE, dataCount, dataPayloadBuffer));
            } else {
                DBRDecoder.readValues(val, DBR_Float.TYPE, dataCount, dataPayloadBuffer);
            }
            val.setPrecision((short)precision);
            retVal = val;
            retVal.setUpperDispLimit(upperDisplay);
            retVal.setUpperAlarmLimit(upperAlarm);
            retVal.setUpperWarningLimit(upperWarning);
            retVal.setLowerWarningLimit(lowerWarning);
            retVal.setLowerAlarmLimit(lowerAlarm);
            retVal.setLowerDispLimit(lowerDisplay);
            retVal.setUpperCtrlLimit(upperControl);
            retVal.setLowerCtrlLimit(lowerControl);
        } else if (dataType == DBR_CTRL_Byte.TYPE) {
            Byte upperDisplay = new Byte(dataPayloadBuffer.get());
            Byte lowerDisplay = new Byte(dataPayloadBuffer.get());
            Byte upperAlarm = new Byte(dataPayloadBuffer.get());
            Byte upperWarning = new Byte(dataPayloadBuffer.get());
            Byte lowerWarning = new Byte(dataPayloadBuffer.get());
            Byte lowerAlarm = new Byte(dataPayloadBuffer.get());
            Byte upperControl = new Byte(dataPayloadBuffer.get());
            Byte lowerControl = new Byte(dataPayloadBuffer.get());
            dataPayloadBuffer.get();
            if (retVal == null) {
                retVal = new DBR_CTRL_Byte((byte[])DBRDecoder.readValues(null, DBR_Byte.TYPE, dataCount, dataPayloadBuffer));
            } else {
                DBRDecoder.readValues(inDBR, DBR_Byte.TYPE, dataCount, dataPayloadBuffer);
            }
            retVal.setUpperDispLimit(upperDisplay);
            retVal.setUpperAlarmLimit(upperAlarm);
            retVal.setUpperWarningLimit(upperWarning);
            retVal.setLowerWarningLimit(lowerWarning);
            retVal.setLowerAlarmLimit(lowerAlarm);
            retVal.setLowerDispLimit(lowerDisplay);
            retVal.setUpperCtrlLimit(upperControl);
            retVal.setLowerCtrlLimit(lowerControl);
        } else if (dataType == DBR_CTRL_Int.TYPE) {
            Integer upperDisplay = new Integer(dataPayloadBuffer.getInt());
            Integer lowerDisplay = new Integer(dataPayloadBuffer.getInt());
            Integer upperAlarm = new Integer(dataPayloadBuffer.getInt());
            Integer upperWarning = new Integer(dataPayloadBuffer.getInt());
            Integer lowerWarning = new Integer(dataPayloadBuffer.getInt());
            Integer lowerAlarm = new Integer(dataPayloadBuffer.getInt());
            Integer upperControl = new Integer(dataPayloadBuffer.getInt());
            Integer lowerControl = new Integer(dataPayloadBuffer.getInt());
            if (retVal == null) {
                retVal = new DBR_CTRL_Int((int[])DBRDecoder.readValues(null, DBR_Int.TYPE, dataCount, dataPayloadBuffer));
            } else {
                DBRDecoder.readValues(inDBR, DBR_Int.TYPE, dataCount, dataPayloadBuffer);
            }
            retVal.setUpperDispLimit(upperDisplay);
            retVal.setUpperAlarmLimit(upperAlarm);
            retVal.setUpperWarningLimit(upperWarning);
            retVal.setLowerWarningLimit(lowerWarning);
            retVal.setLowerAlarmLimit(lowerAlarm);
            retVal.setLowerDispLimit(lowerDisplay);
            retVal.setUpperCtrlLimit(upperControl);
            retVal.setLowerCtrlLimit(lowerControl);
        } else if (dataType == DBR_CTRL_Double.TYPE) {
            Double upperDisplay = new Double(dataPayloadBuffer.getDouble());
            Double lowerDisplay = new Double(dataPayloadBuffer.getDouble());
            Double upperAlarm = new Double(dataPayloadBuffer.getDouble());
            Double upperWarning = new Double(dataPayloadBuffer.getDouble());
            Double lowerWarning = new Double(dataPayloadBuffer.getDouble());
            Double lowerAlarm = new Double(dataPayloadBuffer.getDouble());
            Double upperControl = new Double(dataPayloadBuffer.getDouble());
            Double lowerControl = new Double(dataPayloadBuffer.getDouble());
            DBR_CTRL_Double val = (DBR_CTRL_Double)inDBR;
            if (val == null) {
                val = new DBR_CTRL_Double((double[])DBRDecoder.readValues(null, DBR_Double.TYPE, dataCount, dataPayloadBuffer));
            } else {
                DBRDecoder.readValues(val, DBR_Double.TYPE, dataCount, dataPayloadBuffer);
            }
            val.setPrecision((short)precision);
            retVal = val;
            retVal.setUpperDispLimit(upperDisplay);
            retVal.setUpperAlarmLimit(upperAlarm);
            retVal.setUpperWarningLimit(upperWarning);
            retVal.setLowerWarningLimit(lowerWarning);
            retVal.setLowerAlarmLimit(lowerAlarm);
            retVal.setLowerDispLimit(lowerDisplay);
            retVal.setUpperCtrlLimit(upperControl);
            retVal.setLowerCtrlLimit(lowerControl);
        }
        retVal.setStatus(status);
        retVal.setSeverity(severity);
        retVal.setUnits(units);
        return (DBR)((Object)retVal);
    }

    private static DBR getAckTDBR(DBR inDBR, int dataCount, ByteBuffer dataPayloadBuffer) {
        if (inDBR == null) {
            return new DBR_PutAckT((short[])DBRDecoder.readValues(null, DBR_Short.TYPE, dataCount, dataPayloadBuffer));
        }
        DBRDecoder.readValues(inDBR, DBR_Short.TYPE, dataCount, dataPayloadBuffer);
        return inDBR;
    }

    private static DBR getAckSDBR(DBR inDBR, int dataCount, ByteBuffer dataPayloadBuffer) {
        if (inDBR == null) {
            return new DBR_PutAckS((short[])DBRDecoder.readValues(null, DBR_Short.TYPE, dataCount, dataPayloadBuffer));
        }
        DBRDecoder.readValues(inDBR, DBR_Short.TYPE, dataCount, dataPayloadBuffer);
        return inDBR;
    }

    private static DBR getStatusAckStringDBR(DBR inDBR, int dataCount, ByteBuffer dataPayloadBuffer) {
        int status = dataPayloadBuffer.getShort() & 0xFFFF;
        int severity = dataPayloadBuffer.getShort() & 0xFFFF;
        int ackT = dataPayloadBuffer.getShort() & 0xFFFF;
        int ackS = dataPayloadBuffer.getShort() & 0xFFFF;
        DBR_STSACK_String retVal = (DBR_STSACK_String)inDBR;
        if (retVal == null) {
            retVal = new DBR_STSACK_String((String[])DBRDecoder.readValues(null, DBR_String.TYPE, dataCount, dataPayloadBuffer));
        } else {
            DBRDecoder.readValues(retVal, DBR_String.TYPE, dataCount, dataPayloadBuffer);
        }
        retVal.setStatus(status);
        retVal.setSeverity(severity);
        retVal.setAckT(ackT);
        retVal.setAckS(ackS);
        return retVal;
    }
}

