/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.epics.caj.util;

import java.util.concurrent.PriorityBlockingQueue;

public class Timer
extends Thread {
    protected final PriorityBlockingQueue<TaskNode> heap_ = new PriorityBlockingQueue(64);
    protected Thread thread_;
    protected final RunLoop runLoop_ = new RunLoop();

    public Object executeAfterDelay(long millisecondsToDelay, TimerRunnable command) {
        long runtime = System.currentTimeMillis() + millisecondsToDelay;
        TaskNode task = new TaskNode(runtime, command);
        this.heap_.offer(task);
        this.restart();
        return task;
    }

    public Object executePeriodically(long period, TimerRunnable command, long firstTime) {
        if (period <= 0L) {
            throw new IllegalArgumentException();
        }
        if (firstTime == 0L) {
            firstTime = System.currentTimeMillis();
        }
        TaskNode task = new TaskNode(firstTime, command, period);
        this.heap_.offer(task);
        this.restart();
        return task;
    }

    public static void cancel(Object taskID) {
        ((TaskNode)taskID).setCancelled();
    }

    protected synchronized void clearThread() {
        this.thread_ = null;
    }

    public synchronized void restart() {
        if (this.thread_ == null) {
            this.thread_ = new Thread((Runnable)this.runLoop_, this.getClass().getName());
            this.thread_.start();
        } else {
            this.notify();
        }
    }

    public synchronized void shutDown() {
        this.heap_.clear();
        if (this.thread_ != null) {
            this.thread_.interrupt();
        }
        this.thread_ = null;
    }

    protected synchronized TaskNode nextTask() {
        try {
            while (!Thread.interrupted()) {
                TaskNode task = this.heap_.peek();
                if (task == null) {
                    this.wait();
                    continue;
                }
                long now = System.currentTimeMillis();
                long when = task.getTimeToRun();
                if (when > now) {
                    this.wait(when - now);
                    continue;
                }
                task = this.heap_.poll();
                if (task.getCancelled()) continue;
                if (task.period > 0L) {
                    task.setTimeToRun(when + task.period);
                    this.heap_.offer(task);
                }
                return task;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return null;
    }

    protected class RunLoop
    implements Runnable {
        protected RunLoop() {
        }

        @Override
        public void run() {
            try {
                TaskNode task;
                while ((task = Timer.this.nextTask()) != null) {
                    task.command.timeout(task.getTimeToRun() - task.period);
                }
            }
            finally {
                Timer.this.clearThread();
            }
        }
    }

    private static class TaskNode
    implements Comparable {
        final TimerRunnable command;
        final long period;
        private long timeToRun_;
        private boolean cancelled_ = false;

        synchronized void setCancelled() {
            this.cancelled_ = true;
        }

        synchronized boolean getCancelled() {
            return this.cancelled_;
        }

        synchronized void setTimeToRun(long w) {
            this.timeToRun_ = w;
        }

        synchronized long getTimeToRun() {
            return this.timeToRun_;
        }

        public int compareTo(Object other) {
            long b;
            long a = this.getTimeToRun();
            return a < (b = ((TaskNode)other).getTimeToRun()) ? -1 : (a == b ? 0 : 1);
        }

        TaskNode(long w, TimerRunnable c, long p) {
            this.timeToRun_ = w;
            this.command = c;
            this.period = p;
        }

        TaskNode(long w, TimerRunnable c) {
            this(w, c, -1L);
        }
    }

    public static interface TimerRunnable {
        public void timeout(long var1);
    }
}

