/*
 * Decompiled with CFR 0.152.
 */
package gov.aps.jca;

import gov.aps.jca.CAException;
import gov.aps.jca.Context;
import gov.aps.jca.Monitor;
import gov.aps.jca.ValuedEnum;
import gov.aps.jca.dbr.DBR;
import gov.aps.jca.dbr.DBRType;
import gov.aps.jca.dbr.Severity;
import gov.aps.jca.event.AccessRightsListener;
import gov.aps.jca.event.ConnectionListener;
import gov.aps.jca.event.GetListener;
import gov.aps.jca.event.MonitorListener;
import gov.aps.jca.event.PutListener;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;

public abstract class Channel {
    public static final ConnectionState NEVER_CONNECTED = ConnectionState.NEVER_CONNECTED;
    public static final ConnectionState DISCONNECTED = ConnectionState.DISCONNECTED;
    public static final ConnectionState CONNECTED = ConnectionState.CONNECTED;
    public static final ConnectionState CLOSED = ConnectionState.CLOSED;
    public static final short PRIORITY_MIN = 0;
    public static final short PRIORITY_MAX = 99;
    public static final short PRIORITY_DEFAULT = 0;
    public static final short PRIORITY_LINKS_DB = 99;
    public static final short PRIORITY_ARCHIVE = 49;
    public static final short PRIORITY_OPI = 0;

    public abstract Context getContext() throws IllegalStateException;

    public abstract void destroy() throws CAException, IllegalStateException;

    public abstract ConnectionListener[] getConnectionListeners() throws IllegalStateException;

    public abstract void addConnectionListener(ConnectionListener var1) throws CAException, IllegalStateException;

    public abstract void removeConnectionListener(ConnectionListener var1) throws CAException, IllegalStateException;

    public abstract AccessRightsListener[] getAccessRightsListeners() throws IllegalStateException;

    public abstract void addAccessRightsListener(AccessRightsListener var1) throws CAException, IllegalStateException;

    public abstract void removeAccessRightsListener(AccessRightsListener var1) throws CAException, IllegalStateException;

    public abstract String getName() throws IllegalStateException;

    public abstract DBRType getFieldType() throws IllegalStateException;

    public abstract int getElementCount() throws IllegalStateException;

    public abstract ConnectionState getConnectionState() throws IllegalStateException;

    public abstract String getHostName() throws IllegalStateException;

    public abstract boolean getReadAccess() throws IllegalStateException;

    public abstract boolean getWriteAccess() throws IllegalStateException;

    public void put(byte value) throws CAException, IllegalStateException {
        this.put(new byte[]{value});
    }

    public void put(byte value, PutListener l) throws CAException, IllegalStateException {
        this.put(new byte[]{value}, l);
    }

    public void put(short value) throws CAException, IllegalStateException {
        this.put(new short[]{value});
    }

    public void put(short value, PutListener l) throws CAException, IllegalStateException {
        this.put(new short[]{value}, l);
    }

    public void put(int value) throws CAException, IllegalStateException {
        this.put(new int[]{value});
    }

    public void put(int value, PutListener l) throws CAException, IllegalStateException {
        this.put(new int[]{value}, l);
    }

    public void put(float value) throws CAException, IllegalStateException {
        this.put(new float[]{value});
    }

    public void put(float value, PutListener l) throws CAException, IllegalStateException {
        this.put(new float[]{value}, l);
    }

    public void put(double value) throws CAException, IllegalStateException {
        this.put(new double[]{value});
    }

    public void put(double value, PutListener l) throws CAException, IllegalStateException {
        this.put(new double[]{value}, l);
    }

    public void put(String value) throws CAException, IllegalStateException {
        this.put(new String[]{value});
    }

    public void put(String value, PutListener l) throws CAException, IllegalStateException {
        this.put(new String[]{value}, l);
    }

    public abstract void put(byte[] var1) throws CAException, IllegalStateException;

    public abstract void put(byte[] var1, PutListener var2) throws CAException, IllegalStateException;

    public abstract void put(short[] var1) throws CAException, IllegalStateException;

    public abstract void put(short[] var1, PutListener var2) throws CAException, IllegalStateException;

    public abstract void put(int[] var1) throws CAException, IllegalStateException;

    public abstract void put(int[] var1, PutListener var2) throws CAException, IllegalStateException;

    public abstract void put(float[] var1) throws CAException, IllegalStateException;

    public abstract void put(float[] var1, PutListener var2) throws CAException, IllegalStateException;

    public abstract void put(double[] var1) throws CAException, IllegalStateException;

    public abstract void put(double[] var1, PutListener var2) throws CAException, IllegalStateException;

    public abstract void put(String[] var1) throws CAException, IllegalStateException;

    public abstract void put(String[] var1, PutListener var2) throws CAException, IllegalStateException;

    public abstract void putACKT(boolean var1) throws CAException, IllegalStateException;

    public abstract void putACKT(boolean var1, PutListener var2) throws CAException, IllegalStateException;

    public abstract void putACKS(Severity var1) throws CAException, IllegalStateException;

    public abstract void putACKS(Severity var1, PutListener var2) throws CAException, IllegalStateException;

    public DBR get() throws CAException, IllegalStateException {
        return this.get(this.getFieldType(), this.getElementCount());
    }

    public void get(GetListener l) throws CAException, IllegalStateException {
        this.get(this.getFieldType(), this.getElementCount(), l);
    }

    public DBR get(int count) throws CAException, IllegalStateException {
        return this.get(this.getFieldType(), count);
    }

    public void get(int count, GetListener l) throws CAException, IllegalStateException {
        this.get(this.getFieldType(), count, l);
    }

    public abstract DBR get(DBRType var1, int var2) throws CAException, IllegalStateException;

    public abstract void get(DBRType var1, int var2, GetListener var3) throws CAException, IllegalStateException;

    public Monitor addMonitor(int mask) throws CAException, IllegalStateException {
        return this.addMonitor(this.getFieldType(), this.getElementCount(), mask);
    }

    public Monitor addMonitor(int mask, MonitorListener l) throws CAException, IllegalStateException {
        return this.addMonitor(this.getFieldType(), this.getElementCount(), mask, l);
    }

    public Monitor addMonitor(DBRType type, int count, int mask) throws CAException, IllegalStateException {
        return this.addMonitor(type, count, mask, null);
    }

    public abstract Monitor addMonitor(DBRType var1, int var2, int var3, MonitorListener var4) throws CAException, IllegalStateException;

    protected void checkMonitorSize(DBRType type, int count, int maxArrayBytes) {
        int bytesPerElement = 0;
        if (type.isBYTE()) {
            bytesPerElement = 1;
        } else if (type.isSHORT() || type.isENUM() || type == DBRType.PUT_ACKT || type == DBRType.PUT_ACKS) {
            bytesPerElement = 2;
        } else if (type.isINT() || type.isFLOAT()) {
            bytesPerElement = 4;
        } else if (type.isDOUBLE()) {
            bytesPerElement = 8;
        } else if (type.isSTRING()) {
            bytesPerElement = 40;
        } else {
            throw new IllegalArgumentException("Unsupported data type: " + type);
        }
        if (bytesPerElement * count > maxArrayBytes) {
            throw new IllegalArgumentException("Size of the monitor exceeds maxArrayBytes (" + count + " * " + bytesPerElement + " > " + maxArrayBytes + ")");
        }
    }

    public void printInfo() throws IllegalStateException {
        this.printInfo(System.out);
    }

    public void printInfo(PrintStream out) throws IllegalStateException {
        out.println("CHANNEL  : " + this.getName());
        out.println("TYPE     : " + this.getFieldType());
        out.println("COUNT    : " + this.getElementCount());
        out.println("STATE    : " + this.getConnectionState());
        out.println("HOSTNAME : " + this.getHostName());
        out.println("READ     : " + this.getReadAccess());
        out.println("WRITE    : " + this.getWriteAccess());
    }

    public void dispose() {
        try {
            this.destroy();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static class ConnectionState
    extends ValuedEnum {
        private static Map _map = new HashMap();
        public static final ConnectionState NEVER_CONNECTED = new ConnectionState("NEVER_CONNECTED", 0);
        public static final ConnectionState DISCONNECTED = new ConnectionState("DISCONNECTED", 1);
        public static final ConnectionState CONNECTED = new ConnectionState("CONNECTED", 2);
        public static final ConnectionState CLOSED = new ConnectionState("CLOSED", 3);

        protected ConnectionState(String name, int value) {
            super(name, value, _map);
        }

        public static ConnectionState forValue(int value) {
            for (ConnectionState c : _map.values()) {
                if (c.getValue() != value) continue;
                return c;
            }
            return null;
        }

        public static ConnectionState forName(String name) {
            return (ConnectionState)_map.get(name);
        }
    }
}

