/*
 * Decompiled with CFR 0.152.
 */
package gov.aps.jca.dbr;

import gov.aps.jca.CAStatus;
import gov.aps.jca.CAStatusException;
import gov.aps.jca.dbr.BYTE;
import gov.aps.jca.dbr.DBR;
import gov.aps.jca.dbr.DBRFactory;
import gov.aps.jca.dbr.DBRType;
import gov.aps.jca.dbr.DBR_Double;
import gov.aps.jca.dbr.DBR_Enum;
import gov.aps.jca.dbr.DBR_Float;
import gov.aps.jca.dbr.DBR_Int;
import gov.aps.jca.dbr.DBR_Short;
import gov.aps.jca.dbr.DBR_String;

public class DBR_Byte
extends DBR
implements BYTE {
    public static final DBRType TYPE = new DBRType("DBR_BYTE", 4, DBR_Byte.class);

    public DBR_Byte() {
        this(1);
    }

    public DBR_Byte(int count) {
        this(new byte[count]);
    }

    public DBR_Byte(byte[] value) {
        super(value);
    }

    @Override
    public DBRType getType() {
        return TYPE;
    }

    @Override
    public byte[] getByteValue() {
        return (byte[])this.getValue();
    }

    @Override
    public DBR convert(DBRType convertType) throws CAStatusException {
        if (convertType.isBYTE() && convertType.getValue() <= this.getType().getValue()) {
            return this;
        }
        byte[] fromValue = this.getByteValue();
        DBR dbr = DBRFactory.create(convertType, this._count);
        if (convertType.isSTRING()) {
            String[] toValue = ((DBR_String)dbr).getStringValue();
            for (int i = 0; i < this._count; ++i) {
                toValue[i] = String.valueOf(fromValue[i]);
            }
        } else if (convertType.isSHORT()) {
            short[] toValue = ((DBR_Short)dbr).getShortValue();
            for (int i = 0; i < this._count; ++i) {
                toValue[i] = fromValue[i];
            }
        } else if (convertType.isFLOAT()) {
            float[] toValue = ((DBR_Float)dbr).getFloatValue();
            for (int i = 0; i < this._count; ++i) {
                toValue[i] = fromValue[i];
            }
        } else if (convertType.isENUM()) {
            short[] toValue = ((DBR_Enum)dbr).getEnumValue();
            for (int i = 0; i < this._count; ++i) {
                toValue[i] = fromValue[i];
            }
        } else if (convertType.isBYTE()) {
            byte[] toValue = ((DBR_Byte)dbr).getByteValue();
            for (int i = 0; i < this._count; ++i) {
                toValue[i] = fromValue[i];
            }
        } else if (convertType.isINT()) {
            int[] toValue = ((DBR_Int)dbr).getIntValue();
            for (int i = 0; i < this._count; ++i) {
                toValue[i] = fromValue[i];
            }
        } else if (convertType.isDOUBLE()) {
            double[] toValue = ((DBR_Double)dbr).getDoubleValue();
            for (int i = 0; i < this._count; ++i) {
                toValue[i] = fromValue[i];
            }
        } else {
            throw new CAStatusException(CAStatus.NOCONVERT, "converstion not supported");
        }
        return dbr;
    }
}

