/*
 * Decompiled with CFR 0.152.
 */
package gov.aps.jca.dbr;

import gov.aps.jca.CAStatus;
import gov.aps.jca.CAStatusException;
import gov.aps.jca.dbr.DBR;
import gov.aps.jca.dbr.DBRFactory;
import gov.aps.jca.dbr.DBRType;
import gov.aps.jca.dbr.DBR_Byte;
import gov.aps.jca.dbr.DBR_Double;
import gov.aps.jca.dbr.DBR_Float;
import gov.aps.jca.dbr.DBR_Int;
import gov.aps.jca.dbr.DBR_Short;
import gov.aps.jca.dbr.DBR_String;
import gov.aps.jca.dbr.ENUM;
import gov.aps.jca.dbr.LABELS;

public class DBR_Enum
extends DBR
implements ENUM {
    public static final DBRType TYPE = new DBRType("DBR_ENUM", 3, DBR_Enum.class);

    public DBR_Enum() {
        this(1);
    }

    public DBR_Enum(int count) {
        this(new short[count]);
    }

    public DBR_Enum(short[] value) {
        super(value);
    }

    @Override
    public DBRType getType() {
        return TYPE;
    }

    @Override
    public short[] getEnumValue() {
        return (short[])this.getValue();
    }

    @Override
    public DBR convert(DBRType convertType) throws CAStatusException {
        if (convertType.isENUM() && convertType.getValue() <= this.getType().getValue()) {
            return this;
        }
        short[] fromValue = this.getEnumValue();
        DBR dbr = DBRFactory.create(convertType, this._count);
        if (convertType.isSTRING()) {
            String[] toValue = ((DBR_String)dbr).getStringValue();
            String[] labels = null;
            if (this.isLABELS()) {
                labels = ((LABELS)((Object)this)).getLabels();
            }
            String EMPTY = "";
            if (labels == null) {
                for (int i = 0; i < this._count; ++i) {
                    toValue[i] = "";
                }
            } else {
                for (int i = 0; i < this._count; ++i) {
                    if (fromValue[i] < labels.length) {
                        toValue[i] = labels[fromValue[i]];
                    }
                    if (toValue[i] != null) continue;
                    toValue[i] = "";
                }
            }
        } else if (convertType.isSHORT()) {
            short[] toValue = ((DBR_Short)dbr).getShortValue();
            for (int i = 0; i < this._count; ++i) {
                toValue[i] = fromValue[i];
            }
        } else if (convertType.isFLOAT()) {
            float[] toValue = ((DBR_Float)dbr).getFloatValue();
            for (int i = 0; i < this._count; ++i) {
                toValue[i] = fromValue[i];
            }
        } else if (convertType.isENUM()) {
            short[] toValue = ((DBR_Enum)dbr).getEnumValue();
            for (int i = 0; i < this._count; ++i) {
                toValue[i] = fromValue[i];
            }
        } else if (convertType.isBYTE()) {
            byte[] toValue = ((DBR_Byte)dbr).getByteValue();
            for (int i = 0; i < this._count; ++i) {
                toValue[i] = (byte)fromValue[i];
            }
        } else if (convertType.isINT()) {
            int[] toValue = ((DBR_Int)dbr).getIntValue();
            for (int i = 0; i < this._count; ++i) {
                toValue[i] = fromValue[i];
            }
        } else if (convertType.isDOUBLE()) {
            double[] toValue = ((DBR_Double)dbr).getDoubleValue();
            for (int i = 0; i < this._count; ++i) {
                toValue[i] = fromValue[i];
            }
        } else {
            throw new CAStatusException(CAStatus.NOCONVERT, "converstion not supported");
        }
        return dbr;
    }
}

