/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.epics.caj;

import gov.aps.jca.CAException;
import gov.aps.jca.JCALibrary;
import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.NumberFormat;
import java.text.ParseException;

public class JNIRepeater {
    public static final String JNI_DISABLE_REPEATER = "JNI_DISABLE_REPEATER";

    public static void repeaterInit() throws CAException {
        if (System.getProperties().containsKey(JNI_DISABLE_REPEATER)) {
            return;
        }
        PrivilegedAction action = new PrivilegedAction(){

            public Object run() {
                try {
                    String targetArch = JNIRepeater.getTargetArch();
                    JCALibrary jca = JCALibrary.getInstance();
                    File caRepeaterPath = new File(jca.getProperty("gov.aps.jca.jni.epics." + targetArch + ".caRepeater.path", ""));
                    try {
                        String caRepeater = "caRepeater";
                        if (caRepeaterPath.exists()) {
                            caRepeater = new File(caRepeaterPath, "caRepeater").getAbsolutePath();
                        }
                        Runtime.getRuntime().exec(caRepeater);
                    }
                    catch (IOException ex) {
                        Runtime.getRuntime().exec("caRepeater");
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return null;
            }
        };
        Object res = AccessController.doPrivileged(action);
        if (res != null) {
            throw new CAException("Unable to init JNI CA Repeater", (Throwable)res);
        }
    }

    public static String getTargetArch() {
        String osname = System.getProperty("os.name", "");
        float osversion = 0.0f;
        try {
            osversion = NumberFormat.getInstance().parse(System.getProperty("os.version", "")).floatValue();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        String osarch = System.getProperty("os.arch", "");
        if (osarch.equals("i386") || osarch.equals("i486") || osarch.equals("i586")) {
            osarch = "x86";
        }
        if (osname.equals("SunOS")) {
            if (osversion >= 5.0f) {
                if (osarch.equals("sparc")) {
                    return "solaris-sparc";
                }
                if (osarch.equals("x86")) {
                    return "solaris-x86";
                }
            }
        } else if (osname.equals("Linux")) {
            if (osarch.equals("x86")) {
                return "linux-x86";
            }
        } else {
            if (osname.equals("Mac OS X")) {
                return "darwin-ppc";
            }
            if (osname.startsWith("Win")) {
                return "win32-x86";
            }
        }
        return "unknown";
    }
}

