/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.epics.caj.cas;

import com.cosylab.epics.caj.cas.CAJServerContext;
import com.cosylab.epics.caj.cas.CASTransport;
import com.cosylab.epics.caj.impl.CAContext;
import com.cosylab.epics.caj.impl.reactor.ReactorHandler;
import com.cosylab.epics.caj.impl.reactor.lf.LeaderFollowersHandler;
import gov.aps.jca.CAException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CASAcceptor
implements ReactorHandler {
    private static final Logger logger = Logger.getLogger(CASAcceptor.class.getName());
    private CAContext context;
    private InetSocketAddress bindAddress = null;
    private ServerSocketChannel serverSocketChannel = null;

    public CASAcceptor(CAContext context, int port) throws CAException {
        this.context = context;
        int assignedPort = this.initialize(port);
        if (assignedPort != port) {
            ((CAJServerContext)context).setServerPort(assignedPort);
        }
    }

    @Override
    public void handleEvent(SelectionKey key) {
        if (key.isValid() && key.isAcceptable()) {
            try {
                CASTransport transport;
                ServerSocketChannel serverSocketChannel = (ServerSocketChannel)key.channel();
                SocketChannel socket = serverSocketChannel.accept();
                SocketAddress address = socket.socket().getRemoteSocketAddress();
                this.context.getLogger().finer("Accepted connection from CA client: " + address);
                socket.configureBlocking(false);
                socket.socket().setTcpNoDelay(true);
                socket.socket().setKeepAlive(true);
                Runnable handler = transport = new CASTransport(this.context, socket);
                if (this.context.getLeaderFollowersThreadPool() != null) {
                    handler = new LeaderFollowersHandler(this.context.getReactor(), (ReactorHandler)((Object)handler), this.context.getLeaderFollowersThreadPool());
                }
                this.context.getReactor().register(socket, 1, (ReactorHandler)((Object)handler));
                this.context.getLogger().finer("Serving to CA client: " + address);
            }
            catch (Throwable th) {
                logger.log(Level.SEVERE, "", th);
            }
        }
    }

    /*
     * Loose catch block
     */
    private int initialize(int port) throws CAException {
        this.bindAddress = new InetSocketAddress(port);
        int tryCount = 0;
        while (true) {
            ++tryCount;
            try {
                this.context.getLogger().finer("Creating acceptor to " + this.bindAddress + ".");
                this.serverSocketChannel = ServerSocketChannel.open();
                this.serverSocketChannel.socket().bind(this.bindAddress);
                this.serverSocketChannel.configureBlocking(false);
                if (this.bindAddress.getPort() == 0) {
                    this.bindAddress = new InetSocketAddress(this.serverSocketChannel.socket().getLocalPort());
                    this.context.getLogger().info("Using dynamically assigned TCP port " + this.bindAddress.getPort() + ".");
                }
                ReactorHandler handler = this;
                if (this.context.getLeaderFollowersThreadPool() != null) {
                    handler = new LeaderFollowersHandler(this.context.getReactor(), handler, this.context.getLeaderFollowersThreadPool());
                }
                this.context.getReactor().register(this.serverSocketChannel, 16, handler);
                this.context.getLogger().finer("Accepting connections at " + this.bindAddress + ".");
                return this.bindAddress.getPort();
            }
            catch (BindException be) {
                if (tryCount == 1) {
                    this.context.getLogger().info("Configured TCP port " + port + " is unavailable, trying to assign it dynamically.");
                    this.bindAddress = new InetSocketAddress(0);
                    continue;
                }
                throw new CAException("Failed to create acceptor to " + this.bindAddress, be);
            }
            break;
        }
        catch (Throwable th) {
            throw new CAException("Failed to create acceptor to " + this.bindAddress, th);
        }
    }

    public InetAddress getBindAddress() {
        return this.serverSocketChannel != null ? this.serverSocketChannel.socket().getInetAddress() : null;
    }

    public void destroy() {
        if (this.serverSocketChannel != null) {
            this.context.getLogger().finer("Stopped accepting connections at " + this.bindAddress + ".");
            this.context.getReactor().unregisterAndClose(this.serverSocketChannel);
        }
    }
}

