/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.epics.caj.impl;

import com.cosylab.epics.caj.CAJContext;
import com.cosylab.epics.caj.impl.CATransport;
import com.cosylab.epics.caj.impl.Request;
import com.cosylab.epics.caj.impl.Transport;
import com.cosylab.epics.caj.impl.TransportClient;
import com.cosylab.epics.caj.util.Timer;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.logging.Logger;

public class CAJNameClient
implements TransportClient,
Timer.TimerRunnable,
Request {
    Logger log = Logger.getLogger(CAJNameClient.class.getName());
    final CAJContext context;
    final InetSocketAddress addr;
    Transport transport;
    Object reconnect;
    public final ByteBuffer sendBuffer = ByteBuffer.allocateDirect(1024);

    public CAJNameClient(CAJContext ctxt, InetSocketAddress ep) {
        this.context = ctxt;
        this.addr = ep;
        this.initBuffer();
    }

    public void initBuffer() {
        this.sendBuffer.clear();
    }

    public void connect() {
        CATransport trn = this.context.getTransport(this, this.addr, (short)0, (short)0);
        if (trn != null) {
            this.transport = trn;
            this.log.fine("Connected to name server " + this.addr.toString());
        } else {
            this.transportClosed();
        }
    }

    public void cancel() {
        Object recon = this.reconnect;
        if (recon != null) {
            Timer.cancel(recon);
        }
    }

    @Override
    public void timeout(long timeToRun) {
        this.reconnect = null;
        this.connect();
    }

    @Override
    public void transportUnresponsive() {
    }

    @Override
    public void transportResponsive(Transport transport) {
    }

    @Override
    public void transportChanged() {
    }

    @Override
    public void transportClosed() {
        this.transport = null;
        this.reconnect = this.context.getTimer().executeAfterDelay(10000L, this);
        this.log.fine("Lost connection to name server " + this.addr.toString());
    }

    @Override
    public byte getPriority() {
        return 0;
    }

    @Override
    public ByteBuffer getRequestMessage() {
        return this.sendBuffer;
    }

    @Override
    public void submit() throws IOException {
        Transport trn = this.transport;
        if (trn != null) {
            trn.submit(this);
        }
    }
}

