/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.epics.caj.impl.sync;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

class ReferenceCountingLock {
    private AtomicInteger references = new AtomicInteger(1);
    private Lock lock = new ReentrantLock();

    public boolean acquire(long msecs) {
        try {
            return this.lock.tryLock(msecs, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ie) {
            return false;
        }
    }

    public void release() {
        this.lock.unlock();
    }

    public int increment() {
        return this.references.incrementAndGet();
    }

    public int decrement() {
        return this.references.decrementAndGet();
    }
}

