/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.epics.caj.util.nif;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public class InetAddressUtilV6 {
    public static InetSocketAddress[] getBroadcastAddresses(int port) {
        Enumeration<NetworkInterface> nets;
        try {
            nets = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException se) {
            return new InetSocketAddress[]{new InetSocketAddress("255.255.255.255", port)};
        }
        ArrayList<InetSocketAddress> list = new ArrayList<InetSocketAddress>(10);
        while (nets.hasMoreElements()) {
            NetworkInterface net = nets.nextElement();
            try {
                List<InterfaceAddress> interfaceAddresses;
                if (!net.isUp() || (interfaceAddresses = net.getInterfaceAddresses()) == null) continue;
                for (InterfaceAddress addr : interfaceAddresses) {
                    InetSocketAddress isa;
                    if (addr.getBroadcast() == null || list.contains(isa = new InetSocketAddress(addr.getBroadcast(), port))) continue;
                    list.add(isa);
                }
            }
            catch (Throwable throwable) {
            }
        }
        if (list.size() == 0) {
            list.add(new InetSocketAddress(InetAddress.getLoopbackAddress(), port));
        }
        InetSocketAddress[] retVal = new InetSocketAddress[list.size()];
        list.toArray(retVal);
        return retVal;
    }
}

