/*
 * Decompiled with CFR 0.152.
 */
package gov.aps.jca.cas;

import gov.aps.jca.CAException;
import gov.aps.jca.CAStatus;
import gov.aps.jca.cas.ProcessVariableEventCallback;
import gov.aps.jca.cas.ProcessVariableReadCallback;
import gov.aps.jca.cas.ProcessVariableWriteCallback;
import gov.aps.jca.cas.ServerChannel;
import gov.aps.jca.dbr.DBR;
import gov.aps.jca.dbr.DBRType;
import gov.aps.jca.dbr.Severity;
import java.io.PrintStream;

public abstract class ProcessVariable {
    protected String name;
    protected ProcessVariableEventCallback eventCallback;
    protected volatile boolean interest = false;
    protected int channelCount = 0;
    protected volatile Severity ackS = Severity.NO_ALARM;
    protected volatile boolean ackT = true;

    public ProcessVariable(String name, ProcessVariableEventCallback eventCallback) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("non empty name expected.");
        }
        this.name = name;
        this.eventCallback = eventCallback;
    }

    public String getName() {
        return this.name;
    }

    public abstract DBRType getType();

    public int getMaxDimension() {
        return 0;
    }

    public int getDimensionSize(int dimension) {
        return 1;
    }

    public String[] getEnumLabels() {
        return null;
    }

    public Severity getAckS() {
        return this.ackS;
    }

    public void setAckS(Severity ackS) {
        this.ackS = ackS;
    }

    public boolean isAckT() {
        return this.ackT;
    }

    public void setAckT(boolean ackT) {
        this.ackT = ackT;
    }

    public void interestRegister() {
        this.interest = true;
    }

    public void interestDelete() {
        this.interest = false;
    }

    public abstract CAStatus read(DBR var1, ProcessVariableReadCallback var2) throws CAException;

    public abstract CAStatus write(DBR var1, ProcessVariableWriteCallback var2) throws CAException;

    public ServerChannel createChannel(int cid, int sid, String userName, String hostName) throws CAException {
        return new ServerChannel(this, cid, sid, userName, hostName);
    }

    public synchronized void registerChannel(ServerChannel channel) {
        ++this.channelCount;
    }

    public synchronized void unregisterChannel(ServerChannel channel) {
        --this.channelCount;
        if (this.channelCount == 0) {
            this.destroy();
        }
    }

    public void destroy() {
    }

    public void printInfo() throws IllegalStateException {
        this.printInfo(System.out);
    }

    public void printInfo(PrintStream out) throws IllegalStateException {
        out.println("NAME  : " + this.getName());
    }

    public ProcessVariableEventCallback getEventCallback() {
        return this.eventCallback;
    }

    public void setEventCallback(ProcessVariableEventCallback eventCallback) {
        this.eventCallback = eventCallback;
    }
}

