/*
 * Decompiled with CFR 0.152.
 */
package gov.aps.jca.dbr;

import gov.aps.jca.CAStatusException;
import gov.aps.jca.dbr.DBR;
import gov.aps.jca.dbr.DBRType;
import gov.aps.jca.dbr.DBR_TIME_Float;
import gov.aps.jca.dbr.GR;
import gov.aps.jca.dbr.PRECISION;
import gov.aps.jca.dbr.TimeStamp;
import java.io.PrintStream;

public class DBR_GR_Float
extends DBR_TIME_Float
implements GR,
PRECISION {
    public static final DBRType TYPE = new DBRType("DBR_GR_FLOAT", 23, DBR_GR_Float.class);
    protected String _unit = "";
    protected Float _udl = ZEROF;
    protected Float _ldl = ZEROF;
    protected Float _ual = ZEROF;
    protected Float _uwl = ZEROF;
    protected Float _lwl = ZEROF;
    protected Float _lal = ZEROF;
    protected short _precision;

    public DBR_GR_Float() {
        this(1);
    }

    public DBR_GR_Float(int count) {
        this(new float[count]);
    }

    public DBR_GR_Float(float[] value) {
        super(value);
    }

    @Override
    public DBRType getType() {
        return TYPE;
    }

    @Override
    public short getPrecision() {
        return this._precision;
    }

    @Override
    public void setPrecision(short prec) {
        this._precision = prec;
    }

    @Override
    public String getUnits() {
        return this._unit;
    }

    @Override
    public void setUnits(String unit) {
        this._unit = unit;
    }

    @Override
    public Number getUpperDispLimit() {
        return this._udl;
    }

    @Override
    public void setUpperDispLimit(Number limit) {
        this._udl = new Float(limit.floatValue());
    }

    @Override
    public Number getLowerDispLimit() {
        return this._ldl;
    }

    @Override
    public void setLowerDispLimit(Number limit) {
        this._ldl = new Float(limit.floatValue());
    }

    @Override
    public Number getUpperAlarmLimit() {
        return this._ual;
    }

    @Override
    public void setUpperAlarmLimit(Number limit) {
        this._ual = new Float(limit.floatValue());
    }

    @Override
    public Number getUpperWarningLimit() {
        return this._uwl;
    }

    @Override
    public void setUpperWarningLimit(Number limit) {
        this._uwl = new Float(limit.floatValue());
    }

    @Override
    public Number getLowerWarningLimit() {
        return this._lwl;
    }

    @Override
    public void setLowerWarningLimit(Number limit) {
        this._lwl = new Float(limit.floatValue());
    }

    @Override
    public Number getLowerAlarmLimit() {
        return this._lal;
    }

    @Override
    public void setLowerAlarmLimit(Number limit) {
        this._lal = new Float(limit.floatValue());
    }

    @Override
    public void printInfo(PrintStream out) {
        super.printInfo(out);
        out.println("PRECISION: " + this.getPrecision());
        out.println("UNITS    : " + this.getUnits());
        out.println("UDL      : " + this.getUpperDispLimit());
        out.println("LDL      : " + this.getLowerDispLimit());
        out.println("UAL      : " + this.getUpperAlarmLimit());
        out.println("UWL      : " + this.getUpperWarningLimit());
        out.println("LWL      : " + this.getLowerWarningLimit());
        out.println("LAL      : " + this.getLowerAlarmLimit());
    }

    @Override
    public DBR convert(DBRType convertType) throws CAStatusException {
        DBR dbr = super.convert(convertType);
        if (dbr.isGR()) {
            GR gr = (GR)((Object)dbr);
            gr.setUnits(this.getUnits());
            gr.setUpperDispLimit(this.getUpperDispLimit());
            gr.setLowerDispLimit(this.getLowerDispLimit());
            gr.setUpperAlarmLimit(this.getUpperAlarmLimit());
            gr.setUpperWarningLimit(this.getUpperWarningLimit());
            gr.setLowerWarningLimit(this.getLowerWarningLimit());
            gr.setLowerAlarmLimit(this.getLowerAlarmLimit());
        }
        if (dbr.isPRECSION()) {
            PRECISION prec = (PRECISION)((Object)dbr);
            prec.setPrecision(this.getPrecision());
        }
        return dbr;
    }

    @Override
    public TimeStamp getTimeStamp() {
        return super.getTimeStamp();
    }

    @Override
    public void setTimeStamp(TimeStamp stamp) {
        super.setTimeStamp(stamp);
    }
}

