/*
 * Decompiled with CFR 0.152.
 */
package gov.aps.jca.dbr;

import gov.aps.jca.CAStatus;
import gov.aps.jca.CAStatusException;
import gov.aps.jca.dbr.DBR;
import gov.aps.jca.dbr.DBRFactory;
import gov.aps.jca.dbr.DBRType;
import gov.aps.jca.dbr.DBR_Byte;
import gov.aps.jca.dbr.DBR_Double;
import gov.aps.jca.dbr.DBR_Enum;
import gov.aps.jca.dbr.DBR_Float;
import gov.aps.jca.dbr.DBR_Int;
import gov.aps.jca.dbr.DBR_String;
import gov.aps.jca.dbr.SHORT;

public class DBR_Short
extends DBR
implements SHORT {
    public static final DBRType TYPE = new DBRType("DBR_SHORT", 1, DBR_Short.class);

    public DBR_Short() {
        this(1);
    }

    public DBR_Short(int count) {
        this(new short[count]);
    }

    public DBR_Short(short[] value) {
        super(value);
    }

    @Override
    public DBRType getType() {
        return TYPE;
    }

    @Override
    public short[] getShortValue() {
        return (short[])this.getValue();
    }

    @Override
    public DBR convert(DBRType convertType) throws CAStatusException {
        if (convertType.isSHORT() && convertType.getValue() <= this.getType().getValue()) {
            return this;
        }
        short[] fromValue = this.getShortValue();
        DBR dbr = DBRFactory.create(convertType, this._count);
        if (convertType.isSTRING()) {
            String[] toValue = ((DBR_String)dbr).getStringValue();
            for (int i = 0; i < this._count; ++i) {
                toValue[i] = String.valueOf(fromValue[i]);
            }
        } else if (convertType.isSHORT()) {
            short[] toValue = ((DBR_Short)dbr).getShortValue();
            for (int i = 0; i < this._count; ++i) {
                toValue[i] = fromValue[i];
            }
        } else if (convertType.isFLOAT()) {
            float[] toValue = ((DBR_Float)dbr).getFloatValue();
            for (int i = 0; i < this._count; ++i) {
                toValue[i] = fromValue[i];
            }
        } else if (convertType.isENUM()) {
            short[] toValue = ((DBR_Enum)dbr).getEnumValue();
            for (int i = 0; i < this._count; ++i) {
                toValue[i] = fromValue[i];
            }
        } else if (convertType.isBYTE()) {
            byte[] toValue = ((DBR_Byte)dbr).getByteValue();
            for (int i = 0; i < this._count; ++i) {
                toValue[i] = (byte)fromValue[i];
            }
        } else if (convertType.isINT()) {
            int[] toValue = ((DBR_Int)dbr).getIntValue();
            for (int i = 0; i < this._count; ++i) {
                toValue[i] = fromValue[i];
            }
        } else if (convertType.isDOUBLE()) {
            double[] toValue = ((DBR_Double)dbr).getDoubleValue();
            for (int i = 0; i < this._count; ++i) {
                toValue[i] = fromValue[i];
            }
        } else {
            throw new CAStatusException(CAStatus.NOCONVERT, "converstion not supported");
        }
        return dbr;
    }
}

