/*
 * Decompiled with CFR 0.152.
 */
package gov.aps.jca.event;

import gov.aps.jca.JCALibrary;
import gov.aps.jca.configuration.Configurable;
import gov.aps.jca.configuration.Configuration;
import gov.aps.jca.configuration.ConfigurationException;
import gov.aps.jca.event.AbstractEventDispatcher;
import gov.aps.jca.event.AccessRightsEvent;
import gov.aps.jca.event.AccessRightsListener;
import gov.aps.jca.event.CAEvent;
import gov.aps.jca.event.ConnectionEvent;
import gov.aps.jca.event.ConnectionListener;
import gov.aps.jca.event.ContextExceptionEvent;
import gov.aps.jca.event.ContextExceptionListener;
import gov.aps.jca.event.ContextMessageEvent;
import gov.aps.jca.event.ContextMessageListener;
import gov.aps.jca.event.GetEvent;
import gov.aps.jca.event.GetListener;
import gov.aps.jca.event.MonitorEvent;
import gov.aps.jca.event.MonitorListener;
import gov.aps.jca.event.PutEvent;
import gov.aps.jca.event.PutListener;
import gov.aps.jca.event.SynchronizedLimitedInt;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class LatestMonitorOnlyQueuedEventDispatcher
extends AbstractEventDispatcher
implements Runnable,
Configurable {
    protected static int _count = 0;
    protected volatile boolean _killed = false;
    protected int _priority = 5;
    protected Thread _dispatcherThread = new Thread((Runnable)this, "LatestMonitorOnlyQueuedEventDispatcher-" + _count++);
    protected List _queue;
    protected int _queueLimit = 100;
    protected Map _sourcesEventCount;
    protected int _limit = 5;
    protected Map _overrideMap;
    protected String _monitorOutput = null;
    protected Thread _monitorThread;

    public LatestMonitorOnlyQueuedEventDispatcher() {
        this._dispatcherThread.setDaemon(true);
        this.setPriority(JCALibrary.getInstance().getPropertyAsInt(LatestMonitorOnlyQueuedEventDispatcher.class.getName() + ".priority", this._priority));
        this._queue = new ArrayList();
        this._queueLimit = JCALibrary.getInstance().getPropertyAsInt(LatestMonitorOnlyQueuedEventDispatcher.class.getName() + ".queue_limit", this._queueLimit);
        if (this._queueLimit < 10) {
            this._queueLimit = 10;
        }
        this._sourcesEventCount = new HashMap();
        this._limit = JCALibrary.getInstance().getPropertyAsInt(LatestMonitorOnlyQueuedEventDispatcher.class.getName() + ".channel_queue_limit", this._limit);
        if (this._limit < 3) {
            this._limit = 3;
        }
        this._overrideMap = new HashMap();
        this._monitorOutput = JCALibrary.getInstance().getProperty(LatestMonitorOnlyQueuedEventDispatcher.class.getName() + ".monitor_output", this._monitorOutput);
        if (this._monitorOutput != null) {
            this._monitorThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    LatestMonitorOnlyQueuedEventDispatcher.this.runMonitoring();
                }
            }, this._dispatcherThread.getName() + " monitor");
            this._monitorThread.start();
        }
        this._dispatcherThread.start();
    }

    protected void nonBlockingQueueEvent(Event ev) {
        this.queueEvent(ev, true);
    }

    protected void queueEvent(Event ev) {
        this.queueEvent(ev, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void queueEvent(Event ev, boolean doNotBlockRequired) {
        if (this._killed) {
            return;
        }
        boolean doNotBlock = doNotBlockRequired || Thread.currentThread() == this._dispatcherThread;
        this.incrementSyncCounter(ev, doNotBlock);
        List list = this._queue;
        synchronized (list) {
            while (!doNotBlock && this._queue.size() >= this._queueLimit && !this._killed) {
                try {
                    this._queue.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this._killed) {
                return;
            }
            this._queue.add(ev);
            this._queue.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void incrementSyncCounter(Event ev, boolean doNotBlock) {
        SynchronizedLimitedInt sli;
        Object source = ev._ev.getSource();
        Map map = this._sourcesEventCount;
        synchronized (map) {
            sli = (SynchronizedLimitedInt)this._sourcesEventCount.get(source);
            if (sli == null) {
                this._sourcesEventCount.put(source, new SynchronizedLimitedInt(1, this._limit));
                return;
            }
        }
        sli.increment(doNotBlock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void decrementSyncCounter(Event ev) {
        Object source = ev._ev.getSource();
        Map map = this._sourcesEventCount;
        synchronized (map) {
            SynchronizedLimitedInt sli = (SynchronizedLimitedInt)this._sourcesEventCount.get(source);
            if (sli != null && sli.decrement() <= 0) {
                this._sourcesEventCount.remove(source);
                sli.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int eventsToProcess = 0;
        Event[] eventBatch = new Event[]{};
        while (!this._killed) {
            try {
                List list = this._queue;
                synchronized (list) {
                    while (!this._killed && this._queue.isEmpty()) {
                        this._queue.wait();
                    }
                    if (!this._killed) {
                        eventsToProcess = this._queue.size();
                        if (eventsToProcess > eventBatch.length) {
                            eventBatch = new Event[eventsToProcess];
                        }
                        this._queue.toArray(eventBatch);
                        this._queue.clear();
                        this._queue.notifyAll();
                    }
                }
                for (int i = 0; !this._killed && i < eventsToProcess; ++i) {
                    Event event = eventBatch[i];
                    try {
                        Object overrideId = eventBatch[i]._overrideId;
                        if (overrideId != null) {
                            Map map = this._overrideMap;
                            synchronized (map) {
                                this._overrideMap.remove(overrideId);
                            }
                        }
                        event.dispatch();
                    }
                    catch (Throwable th) {
                        th.printStackTrace();
                    }
                    this.decrementSyncCounter(eventBatch[i]);
                    eventBatch[i] = null;
                    Thread.yield();
                }
            }
            catch (Throwable th) {
                th.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        this._killed = true;
        this._dispatcherThread = null;
        Object object = this._queue;
        synchronized (object) {
            this._queue.notifyAll();
        }
        object = this._sourcesEventCount;
        synchronized (object) {
            Iterator iter = this._sourcesEventCount.values().iterator();
            while (iter.hasNext()) {
                ((SynchronizedLimitedInt)iter.next()).destroy();
            }
            this._sourcesEventCount.clear();
        }
        object = this._overrideMap;
        synchronized (object) {
            this._overrideMap.clear();
        }
    }

    @Override
    public void configure(Configuration conf) throws ConfigurationException {
        int priority = this.getPriority();
        try {
            priority = conf.getChild("priority").getValueAsInteger();
        }
        catch (Exception ex) {
            priority = conf.getAttributeAsInteger("priority", priority);
        }
        this.setPriority(priority);
    }

    public int getPriority() {
        return this._priority;
    }

    public void setPriority(int priority) {
        if (this._killed) {
            throw new IllegalStateException("Dispatcher thread has been killed");
        }
        this._priority = priority;
        this._dispatcherThread.setPriority(this._priority);
    }

    @Override
    public void dispatch(ContextMessageEvent ev, List listeners) {
        if (this._killed) {
            return;
        }
        this.nonBlockingQueueEvent(new Event((CAEvent)ev, listeners.toArray()){

            @Override
            public void dispatch() {
                for (int t = 0; t < this._listeners.length; ++t) {
                    if (!(this._listeners[t] instanceof ContextMessageListener)) continue;
                    ((ContextMessageListener)this._listeners[t]).contextMessage((ContextMessageEvent)this._ev);
                }
            }
        });
    }

    @Override
    public void dispatch(ContextExceptionEvent ev, List listeners) {
        if (this._killed) {
            return;
        }
        this.nonBlockingQueueEvent(new Event((CAEvent)ev, listeners.toArray()){

            @Override
            public void dispatch() {
                for (int t = 0; t < this._listeners.length; ++t) {
                    if (!(this._listeners[t] instanceof ContextExceptionListener)) continue;
                    ((ContextExceptionListener)this._listeners[t]).contextException((ContextExceptionEvent)this._ev);
                }
            }
        });
    }

    @Override
    public void dispatch(ConnectionEvent ev, List listeners) {
        if (this._killed) {
            return;
        }
        this.nonBlockingQueueEvent(new Event((CAEvent)ev, listeners.toArray()){

            @Override
            public void dispatch() {
                for (int t = 0; t < this._listeners.length; ++t) {
                    if (!(this._listeners[t] instanceof ConnectionListener)) continue;
                    ((ConnectionListener)this._listeners[t]).connectionChanged((ConnectionEvent)this._ev);
                }
            }
        });
    }

    @Override
    public void dispatch(AccessRightsEvent ev, List listeners) {
        if (this._killed) {
            return;
        }
        this.nonBlockingQueueEvent(new Event((CAEvent)ev, listeners.toArray()){

            @Override
            public void dispatch() {
                for (int t = 0; t < this._listeners.length; ++t) {
                    if (!(this._listeners[t] instanceof AccessRightsListener)) continue;
                    ((AccessRightsListener)this._listeners[t]).accessRightsChanged((AccessRightsEvent)this._ev);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispatch(MonitorEvent ev, List listeners) {
        if (this._killed) {
            return;
        }
        if (listeners.size() == 1) {
            this.dispatch(ev, (MonitorListener)listeners.get(0));
            return;
        }
        Map map = this._overrideMap;
        synchronized (map) {
            Event existingEvent = (Event)this._overrideMap.get(ev.getSource());
            if (existingEvent != null) {
                existingEvent._ev = ev;
            } else {
                Event event = new Event((CAEvent)ev, listeners.toArray(), ev.getSource()){

                    @Override
                    public void dispatch() {
                        for (int t = 0; t < this._listeners.length; ++t) {
                            if (!(this._listeners[t] instanceof MonitorListener)) continue;
                            ((MonitorListener)this._listeners[t]).monitorChanged((MonitorEvent)this._ev);
                        }
                    }
                };
                this._overrideMap.put(ev.getSource(), event);
                this.queueEvent(event);
            }
        }
    }

    @Override
    public void dispatch(GetEvent ev, List listeners) {
        if (this._killed) {
            return;
        }
        this.queueEvent(new Event((CAEvent)ev, listeners.toArray()){

            @Override
            public void dispatch() {
                for (int t = 0; t < this._listeners.length; ++t) {
                    if (!(this._listeners[t] instanceof GetListener)) continue;
                    ((GetListener)this._listeners[t]).getCompleted((GetEvent)this._ev);
                }
            }
        });
    }

    @Override
    public void dispatch(PutEvent ev, List listeners) {
        if (this._killed) {
            return;
        }
        this.queueEvent(new Event((CAEvent)ev, listeners.toArray()){

            @Override
            public void dispatch() {
                for (int t = 0; t < this._listeners.length; ++t) {
                    if (!(this._listeners[t] instanceof PutListener)) continue;
                    ((PutListener)this._listeners[t]).putCompleted((PutEvent)this._ev);
                }
            }
        });
    }

    @Override
    public void dispatch(ContextMessageEvent ev, ContextMessageListener cml) {
        if (this._killed) {
            return;
        }
        this.nonBlockingQueueEvent(new Event((CAEvent)ev, cml){

            @Override
            public void dispatch() {
                try {
                    ((ContextMessageListener)this._listener).contextMessage((ContextMessageEvent)this._ev);
                }
                catch (Throwable th) {
                    th.printStackTrace();
                }
            }
        });
    }

    @Override
    public void dispatch(ContextExceptionEvent ev, ContextExceptionListener cel) {
        if (this._killed) {
            return;
        }
        this.nonBlockingQueueEvent(new Event((CAEvent)ev, cel){

            @Override
            public void dispatch() {
                try {
                    ((ContextExceptionListener)this._listener).contextException((ContextExceptionEvent)this._ev);
                }
                catch (Throwable th) {
                    th.printStackTrace();
                }
            }
        });
    }

    @Override
    public void dispatch(ConnectionEvent ev, ConnectionListener cl) {
        if (this._killed) {
            return;
        }
        this.nonBlockingQueueEvent(new Event((CAEvent)ev, cl){

            @Override
            public void dispatch() {
                try {
                    ((ConnectionListener)this._listener).connectionChanged((ConnectionEvent)this._ev);
                }
                catch (Throwable th) {
                    th.printStackTrace();
                }
            }
        });
    }

    @Override
    public void dispatch(AccessRightsEvent ev, AccessRightsListener arl) {
        if (this._killed) {
            return;
        }
        this.nonBlockingQueueEvent(new Event((CAEvent)ev, arl){

            @Override
            public void dispatch() {
                try {
                    ((AccessRightsListener)this._listener).accessRightsChanged((AccessRightsEvent)this._ev);
                }
                catch (Throwable th) {
                    th.printStackTrace();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispatch(MonitorEvent ev, MonitorListener ml) {
        if (this._killed) {
            return;
        }
        Event event = null;
        Map map = this._overrideMap;
        synchronized (map) {
            Event existingEvent = (Event)this._overrideMap.get(ev.getSource());
            if (existingEvent != null && existingEvent._listener == ml) {
                existingEvent._ev = ev;
            } else {
                event = new Event((CAEvent)ev, ml, ev.getSource()){

                    @Override
                    public void dispatch() {
                        try {
                            ((MonitorListener)this._listener).monitorChanged((MonitorEvent)this._ev);
                        }
                        catch (Throwable th) {
                            th.printStackTrace();
                        }
                    }
                };
                this._overrideMap.put(ev.getSource(), event);
            }
        }
        if (event != null) {
            this.queueEvent(event);
        }
    }

    @Override
    public void dispatch(GetEvent ev, GetListener gl) {
        if (this._killed) {
            return;
        }
        this.queueEvent(new Event((CAEvent)ev, gl){

            @Override
            public void dispatch() {
                try {
                    ((GetListener)this._listener).getCompleted((GetEvent)this._ev);
                }
                catch (Throwable th) {
                    th.printStackTrace();
                }
            }
        });
    }

    @Override
    public void dispatch(PutEvent ev, PutListener pl) {
        if (this._killed) {
            return;
        }
        this.queueEvent(new Event((CAEvent)ev, pl){

            @Override
            public void dispatch() {
                try {
                    ((PutListener)this._listener).putCompleted((PutEvent)this._ev);
                }
                catch (Throwable th) {
                    th.printStackTrace();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runMonitoring() {
        PrintStream output;
        if (this._monitorOutput == null) {
            return;
        }
        if (this._monitorOutput.equals("stdout")) {
            output = System.out;
        } else if (this._monitorOutput.equals("stderr")) {
            output = System.err;
        } else {
            try {
                output = new PrintStream(this._monitorOutput);
            }
            catch (FileNotFoundException e) {
                System.err.println("Failed to open monitoring output file '" + this._monitorOutput + "', falling back to stdout.");
                e.printStackTrace();
                output = System.out;
            }
        }
        SimpleDateFormat ISO8601FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        while (!this._killed) {
            List list = this._queue;
            synchronized (list) {
                output.println(ISO8601FORMAT.format(new Date()) + "\t" + this._queue.size());
            }
            output.flush();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        output.close();
    }

    abstract class Event {
        CAEvent _ev;
        final EventListener _listener;
        final Object[] _listeners;
        final Object _overrideId;

        Event(CAEvent ev, Object[] listeners) {
            this(ev, listeners, null);
        }

        Event(CAEvent ev, Object[] listeners, Object overrideId) {
            this._ev = ev;
            this._listener = null;
            this._listeners = listeners;
            this._overrideId = overrideId;
        }

        Event(CAEvent ev, EventListener listener) {
            this(ev, listener, null);
        }

        Event(CAEvent ev, EventListener listener, Object overrideId) {
            this._ev = ev;
            this._listener = listener;
            this._listeners = null;
            this._overrideId = overrideId;
        }

        public abstract void dispatch();
    }
}

