/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.epics.caj;

import com.cosylab.epics.caj.CAJChannel;
import com.cosylab.epics.caj.CAJConstants;
import com.cosylab.epics.caj.CARepeater;
import com.cosylab.epics.caj.impl.BroadcastConnector;
import com.cosylab.epics.caj.impl.BroadcastTransport;
import com.cosylab.epics.caj.impl.CABeaconHandler;
import com.cosylab.epics.caj.impl.CAConnector;
import com.cosylab.epics.caj.impl.CAContext;
import com.cosylab.epics.caj.impl.CAJNameClient;
import com.cosylab.epics.caj.impl.CAResponseHandler;
import com.cosylab.epics.caj.impl.CATransport;
import com.cosylab.epics.caj.impl.CATransportRegistry;
import com.cosylab.epics.caj.impl.CachedByteBufferAllocator;
import com.cosylab.epics.caj.impl.ChannelSearchManager;
import com.cosylab.epics.caj.impl.ConnectionException;
import com.cosylab.epics.caj.impl.RepeaterRegistrationTask;
import com.cosylab.epics.caj.impl.ResponseRequest;
import com.cosylab.epics.caj.impl.Transport;
import com.cosylab.epics.caj.impl.TransportClient;
import com.cosylab.epics.caj.impl.reactor.Reactor;
import com.cosylab.epics.caj.impl.reactor.ReactorHandler;
import com.cosylab.epics.caj.impl.reactor.lf.LeaderFollowersHandler;
import com.cosylab.epics.caj.impl.reactor.lf.LeaderFollowersThreadPool;
import com.cosylab.epics.caj.impl.sync.NamedLockPattern;
import com.cosylab.epics.caj.util.InetAddressUtil;
import com.cosylab.epics.caj.util.IntHashMap;
import com.cosylab.epics.caj.util.Timer;
import com.cosylab.epics.caj.util.logging.ConsoleLogHandler;
import gov.aps.jca.CAException;
import gov.aps.jca.Channel;
import gov.aps.jca.Context;
import gov.aps.jca.JCALibrary;
import gov.aps.jca.TimeoutException;
import gov.aps.jca.Version;
import gov.aps.jca.configuration.Configurable;
import gov.aps.jca.configuration.Configuration;
import gov.aps.jca.configuration.ConfigurationException;
import gov.aps.jca.event.ConnectionListener;
import gov.aps.jca.event.ContextExceptionEvent;
import gov.aps.jca.event.ContextExceptionListener;
import gov.aps.jca.event.ContextMessageListener;
import gov.aps.jca.event.DirectEventDispatcher;
import gov.aps.jca.event.EventDispatcher;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.channels.DatagramChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CAJContext
extends Context
implements CAContext,
CAJConstants,
Configurable {
    private static final int CAJ_VERSION_MAJOR = 1;
    private static final int CAJ_VERSION_MINOR = 1;
    private static final int CAJ_VERSION_MAINTENANCE = 16;
    private static final int CAJ_VERSION_DEVELOPMENT = 1;
    public static final Version VERSION = new Version("Channel Access in Java", "Java", 1, 1, 16, 1);
    public static final String CAJ_SINGLE_THREADED_MODEL = "CAJ_SINGLE_THREADED_MODEL";
    private static final int NOT_INITIALIZED = 0;
    private static final int INITIALIZED = 1;
    private static final int DESTROYED = 2;
    private volatile int state = 0;
    protected Logger logger = Logger.global;
    protected String addressList = "";
    protected boolean autoAddressList = true;
    protected String nameServersList = "";
    protected float connectionTimeout = 30.0f;
    protected float beaconPeriod = 15.0f;
    protected float beaconSpeedup = 0.8f;
    protected float beaconSlowdown = 1.25f;
    protected long echoTimeout = 5000L;
    protected int repeaterPort = 5065;
    protected int serverPort = 5064;
    protected int maxArrayBytes = 16384;
    protected float minSearchInterval = 0.1f;
    protected float maxSearchInterval = 300.0f;
    protected ArrayList contextMessageListeners = new ArrayList();
    protected ArrayList contextExceptionListeners = new ArrayList();
    protected EventDispatcher eventDispatcher = new DirectEventDispatcher();
    protected Timer timer = null;
    protected Reactor reactor = null;
    protected LeaderFollowersThreadPool leaderFollowersThreadPool = null;
    protected boolean registrationConfirmed = false;
    private Object registrationConfirmedCondition = new Object();
    protected BroadcastTransport broadcastTransport = null;
    protected CAConnector connector = null;
    public ArrayList<CAJNameClient> nameClients = new ArrayList();
    protected CATransportRegistry transportRegistry = null;
    protected CachedByteBufferAllocator cachedBufferAllocator = new CachedByteBufferAllocator();
    private NamedLockPattern namedLocker;
    private static final int LOCK_TIMEOUT = 20000;
    protected IntHashMap channelsByCID = new IntHashMap();
    protected Map channelsByName = new HashMap();
    private int lastCID = 0;
    protected IntHashMap pendingResponseRequests = new IntHashMap();
    private int lastIOID = 0;
    private AtomicInteger pendingRequestsCount = new AtomicInteger(0);
    private AtomicInteger sequenceNumberIO = new AtomicInteger(0);
    private Object zeroPendingRequestsCondition = new Object();
    private ChannelSearchManager channelSearchManager;
    protected Map beaconHandlers = new HashMap();
    private AtomicInteger lastReceivedSequenceNumber = new AtomicInteger(0);
    private AtomicBoolean doNotShareChannels = new AtomicBoolean(System.getProperties().containsValue("CAJ_DO_NOT_SHARE_CHANNELS"));
    private volatile String userName = System.getProperty("user.name", "nobody");

    public CAJContext() {
        this.initializeLogger();
        this.loadConfiguration();
    }

    @Override
    public Version getVersion() {
        return VERSION;
    }

    public boolean isDoNotShareChannels() {
        return this.doNotShareChannels.get();
    }

    public void setDoNotShareChannels(boolean doNotShareChannels) {
        if (this.doNotShareChannels.get() == doNotShareChannels) {
            return;
        }
        if (this.state != 0) {
            throw new IllegalStateException("Cannot change doNotShareChannels after the Context is initialized.");
        }
        this.doNotShareChannels.set(doNotShareChannels);
    }

    protected void initializeLogger() {
        JCALibrary jcaLibrary = JCALibrary.getInstance();
        String thisClassName = this.getClass().getName();
        String loggerName = jcaLibrary.getProperty(thisClassName + ".logger", thisClassName);
        this.logger = Logger.getLogger(loggerName);
        if (System.getProperties().containsKey("CAJ_DEBUG")) {
            this.logger.setLevel(Level.ALL);
            this.logger.addHandler(new ConsoleLogHandler());
        }
    }

    protected void loadConfiguration() {
        JCALibrary jcaLibrary = JCALibrary.getInstance();
        String eventDispatcherClassName = null;
        String thisClassName = this.getClass().getName();
        if (Boolean.getBoolean("jca.use_env")) {
            eventDispatcherClassName = jcaLibrary.getProperty(Context.class.getName() + ".event_dispatcher", eventDispatcherClassName);
            String tmp = System.getenv("EPICS_CA_ADDR_LIST");
            if (tmp != null) {
                this.addressList = tmp;
            }
            this.autoAddressList = (tmp = System.getenv("EPICS_CA_AUTO_ADDR_LIST")) != null ? !tmp.equalsIgnoreCase("NO") : true;
            tmp = System.getenv("EPICS_CA_NAME_SERVERS");
            if (tmp != null) {
                this.nameServersList = tmp;
            }
            if ((tmp = System.getenv("EPICS_CA_CONN_TMO")) != null) {
                try {
                    this.connectionTimeout = Float.parseFloat(tmp);
                }
                catch (Exception ex) {
                    this.logger.log(Level.WARNING, "Cannot parse EPICS_CA_CONN_TMO='" + tmp + "'", ex);
                }
            }
            if ((tmp = System.getenv("EPICS_CA_BEACON_PERIOD")) != null) {
                try {
                    this.beaconPeriod = Float.parseFloat(tmp);
                }
                catch (Exception ex) {
                    this.logger.log(Level.WARNING, "Cannot parse EPICS_CA_BEACON_PERIOD='" + tmp + "'", ex);
                }
            }
            if ((tmp = System.getenv("EPICS_CA_ECHO_TIMEOUT")) != null) {
                try {
                    this.echoTimeout = Integer.parseInt(tmp);
                }
                catch (Exception ex) {
                    this.logger.log(Level.WARNING, "Cannot parse EPICS_CA_ECHO_TIMEOUT='" + tmp + "'", ex);
                }
            }
            if ((tmp = System.getenv("EPICS_CA_REPEATER_PORT")) != null) {
                try {
                    this.repeaterPort = Integer.parseInt(tmp);
                }
                catch (Exception ex) {
                    this.logger.log(Level.WARNING, "Cannot parse EPICS_CA_REPEATER_PORT='" + tmp + "'", ex);
                }
            }
            if ((tmp = System.getenv("EPICS_CA_SERVER_PORT")) != null) {
                try {
                    this.serverPort = Integer.parseInt(tmp);
                }
                catch (Exception ex) {
                    this.logger.log(Level.WARNING, "Cannot parse EPICS_CA_SERVER_PORT='" + tmp + "'", ex);
                }
            }
            if ((tmp = System.getenv("EPICS_CA_MAX_ARRAY_BYTES")) != null) {
                try {
                    this.maxArrayBytes = Integer.parseInt(tmp);
                }
                catch (Exception ex) {
                    this.logger.log(Level.WARNING, "Cannot parse EPICS_CA_MAX_ARRAY_BYTES='" + tmp + "'", ex);
                }
            }
            if ((tmp = System.getenv("EPICS_CA_MAX_SEARCH_PERIOD")) != null) {
                try {
                    this.maxSearchInterval = Float.parseFloat(tmp);
                }
                catch (Exception ex) {
                    this.logger.log(Level.WARNING, "Cannot parse EPICS_CA_MAX_SEARCH_PERIOD='" + tmp + "'", ex);
                }
            }
        } else {
            String contextClassName = Context.class.getName();
            this.addressList = jcaLibrary.getProperty(contextClassName + ".addr_list", this.addressList);
            this.autoAddressList = jcaLibrary.getPropertyAsBoolean(contextClassName + ".auto_addr_list", this.autoAddressList);
            this.nameServersList = jcaLibrary.getProperty(contextClassName + ".name_servers", this.nameServersList);
            this.connectionTimeout = jcaLibrary.getPropertyAsFloat(contextClassName + ".connection_timeout", this.connectionTimeout);
            this.beaconPeriod = jcaLibrary.getPropertyAsFloat(contextClassName + ".beacon_period", this.beaconPeriod);
            this.echoTimeout = jcaLibrary.getPropertyAsLong(contextClassName + ".echo_timeout", this.echoTimeout);
            this.repeaterPort = jcaLibrary.getPropertyAsInt(contextClassName + ".repeater_port", this.repeaterPort);
            this.serverPort = jcaLibrary.getPropertyAsInt(contextClassName + ".server_port", this.serverPort);
            this.maxArrayBytes = jcaLibrary.getPropertyAsInt(contextClassName + ".max_array_bytes", this.maxArrayBytes);
            this.maxSearchInterval = jcaLibrary.getPropertyAsFloat(contextClassName + ".max_search_interval", this.maxSearchInterval);
            eventDispatcherClassName = jcaLibrary.getProperty(contextClassName + ".event_dispatcher");
            this.addressList = jcaLibrary.getProperty(thisClassName + ".addr_list", this.addressList);
            this.autoAddressList = jcaLibrary.getPropertyAsBoolean(thisClassName + ".auto_addr_list", this.autoAddressList);
            this.nameServersList = jcaLibrary.getProperty(thisClassName + ".name_servers", this.nameServersList);
            this.connectionTimeout = jcaLibrary.getPropertyAsFloat(thisClassName + ".connection_timeout", this.connectionTimeout);
            this.beaconPeriod = jcaLibrary.getPropertyAsFloat(thisClassName + ".beacon_period", this.beaconPeriod);
            this.beaconSpeedup = jcaLibrary.getPropertyAsFloat(thisClassName + ".beacon_speedup", this.beaconSpeedup);
            this.beaconSlowdown = jcaLibrary.getPropertyAsFloat(thisClassName + ".beacon_slowdown", this.beaconSlowdown);
            this.echoTimeout = jcaLibrary.getPropertyAsLong(thisClassName + ".echo_timeout", this.echoTimeout);
            this.repeaterPort = jcaLibrary.getPropertyAsInt(thisClassName + ".repeater_port", this.repeaterPort);
            this.serverPort = jcaLibrary.getPropertyAsInt(thisClassName + ".server_port", this.serverPort);
            this.maxArrayBytes = jcaLibrary.getPropertyAsInt(thisClassName + ".max_array_bytes", this.maxArrayBytes);
            this.minSearchInterval = jcaLibrary.getPropertyAsFloat(thisClassName + ".min_search_interval", this.minSearchInterval);
            this.maxSearchInterval = jcaLibrary.getPropertyAsFloat(thisClassName + ".max_search_interval", this.maxSearchInterval);
        }
        if ((eventDispatcherClassName = jcaLibrary.getProperty(thisClassName + ".event_dispatcher", eventDispatcherClassName)) != null) {
            try {
                this.eventDispatcher = (EventDispatcher)Class.forName(eventDispatcherClassName).newInstance();
            }
            catch (Throwable th) {
                this.logger.log(Level.WARNING, "Failed to instantiate '" + eventDispatcherClassName + "' event dispatcher.", th);
            }
        }
    }

    @Override
    public void configure(Configuration configuration) throws ConfigurationException {
        try {
            this.addressList = configuration.getChild("addr_list", false).getValue();
        }
        catch (Exception ex) {
            this.addressList = configuration.getAttribute("addr_list", this.addressList);
        }
        try {
            this.autoAddressList = configuration.getChild("auto_addr_list", false).getValueAsBoolean();
        }
        catch (Exception ex) {
            this.autoAddressList = configuration.getAttributeAsBoolean("auto_addr_list", this.autoAddressList);
        }
        try {
            this.connectionTimeout = configuration.getChild("connection_timeout", false).getValueAsFloat();
        }
        catch (Exception ex) {
            this.connectionTimeout = configuration.getAttributeAsFloat("connection_timeout", this.connectionTimeout);
        }
        try {
            this.beaconPeriod = configuration.getChild("beacon_period", false).getValueAsFloat();
        }
        catch (Exception ex) {
            this.beaconPeriod = configuration.getAttributeAsFloat("beacon_period", this.beaconPeriod);
        }
        try {
            this.echoTimeout = configuration.getChild("echo_timeout", false).getValueAsLong();
        }
        catch (Exception ex) {
            this.echoTimeout = configuration.getAttributeAsLong("echo_timeout", this.echoTimeout);
        }
        try {
            this.repeaterPort = configuration.getChild("repeater_port", false).getValueAsInteger();
        }
        catch (Exception ex) {
            this.repeaterPort = configuration.getAttributeAsInteger("repeater_port", this.repeaterPort);
        }
        try {
            this.serverPort = configuration.getChild("server_port", false).getValueAsInteger();
        }
        catch (Exception ex) {
            this.serverPort = configuration.getAttributeAsInteger("server_port", this.serverPort);
        }
        try {
            this.maxArrayBytes = configuration.getChild("max_array_bytes", false).getValueAsInteger();
        }
        catch (Exception ex) {
            this.maxArrayBytes = configuration.getAttributeAsInteger("max_array_bytes", this.maxArrayBytes);
        }
        try {
            this.maxSearchInterval = configuration.getChild("max_search_interval", false).getValueAsFloat();
        }
        catch (Exception ex) {
            this.maxSearchInterval = configuration.getAttributeAsFloat("max_search_interval", this.maxSearchInterval);
        }
        Configuration conf = configuration.getChild("event_dispatcher", false);
        if (conf != null) {
            String eventDispatcherClassName = null;
            try {
                eventDispatcherClassName = conf.getAttribute("class");
            }
            catch (ConfigurationException noAttribute) {
                this.logger.log(Level.WARNING, "Failed to obtain 'event_dispatcher' node's 'class' attribute.", noAttribute);
            }
            if (eventDispatcherClassName != null) {
                try {
                    this.eventDispatcher = (EventDispatcher)Class.forName(eventDispatcherClassName).newInstance();
                }
                catch (Throwable th) {
                    this.logger.log(Level.WARNING, "Failed to instantiate '" + eventDispatcherClassName + "' event dispatcher.", th);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ContextMessageListener[] getContextMessageListeners() throws IllegalStateException {
        ArrayList arrayList = this.contextMessageListeners;
        synchronized (arrayList) {
            ContextMessageListener[] listeners = new ContextMessageListener[this.contextMessageListeners.size()];
            return this.contextMessageListeners.toArray(listeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addContextMessageListener(ContextMessageListener l) throws CAException, IllegalStateException {
        this.checkState();
        if (l == null) {
            throw new IllegalArgumentException("l == null");
        }
        ArrayList arrayList = this.contextMessageListeners;
        synchronized (arrayList) {
            if (!this.contextMessageListeners.contains(l)) {
                this.contextMessageListeners.add(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeContextMessageListener(ContextMessageListener l) throws CAException, IllegalStateException {
        this.checkState();
        if (l == null) {
            throw new IllegalArgumentException("l == null");
        }
        ArrayList arrayList = this.contextMessageListeners;
        synchronized (arrayList) {
            this.contextMessageListeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ContextExceptionListener[] getContextExceptionListeners() throws IllegalStateException {
        ArrayList arrayList = this.contextExceptionListeners;
        synchronized (arrayList) {
            ContextExceptionListener[] listeners = new ContextExceptionListener[this.contextExceptionListeners.size()];
            return this.contextExceptionListeners.toArray(listeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addContextExceptionListener(ContextExceptionListener l) throws CAException, IllegalStateException {
        this.checkState();
        if (l == null) {
            throw new IllegalArgumentException("l == null");
        }
        ArrayList arrayList = this.contextExceptionListeners;
        synchronized (arrayList) {
            if (!this.contextExceptionListeners.contains(l)) {
                this.contextExceptionListeners.add(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeContextExceptionListener(ContextExceptionListener l) throws CAException, IllegalStateException {
        this.checkState();
        if (l == null) {
            throw new IllegalArgumentException("l == null");
        }
        ArrayList arrayList = this.contextExceptionListeners;
        synchronized (arrayList) {
            this.contextExceptionListeners.remove(l);
        }
    }

    public void notifyException(ContextExceptionEvent event) {
        ContextExceptionListener[] listeners = this.getContextExceptionListeners();
        for (int i = 0; i < listeners.length; ++i) {
            try {
                listeners[i].contextException(event);
                continue;
            }
            catch (Throwable th) {
                this.logger.log(Level.SEVERE, "", th);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkState() throws CAException, IllegalStateException {
        if (this.state == 2) {
            throw new IllegalStateException("Context destroyed.");
        }
        if (this.state == 0) {
            CAJContext cAJContext = this;
            synchronized (cAJContext) {
                if (this.state == 0) {
                    this.initialize();
                }
            }
        }
    }

    @Override
    public synchronized void initialize() throws CAException {
        if (this.state == 2) {
            throw new IllegalStateException("Context destroyed.");
        }
        if (this.state == 1) {
            throw new IllegalStateException("Context already initialized.");
        }
        super.initialize();
        this.internalInitialize();
        this.state = 1;
    }

    private void internalInitialize() throws CAException {
        try {
            CARepeater.startRepeater(this.repeaterPort);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.timer = new Timer();
        this.connector = new CAConnector(this);
        this.transportRegistry = new CATransportRegistry();
        this.namedLocker = new NamedLockPattern();
        try {
            this.reactor = new Reactor();
            if (System.getProperties().containsKey(CAJ_SINGLE_THREADED_MODEL)) {
                this.logger.config("Using single threaded model.");
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        while (CAJContext.this.reactor.process()) {
                        }
                    }
                }, "CA reactor").start();
            } else {
                this.leaderFollowersThreadPool = new LeaderFollowersThreadPool();
                this.leaderFollowersThreadPool.promoteLeader(new Runnable(){

                    @Override
                    public void run() {
                        CAJContext.this.reactor.process();
                    }
                });
            }
        }
        catch (IOException ioex) {
            throw new CAException("Failed to initialize reactor.", ioex);
        }
        this.initializeUDPTransport();
        this.initializeNameServers();
        this.channelSearchManager = new ChannelSearchManager(this);
    }

    private void initializeNameServers() {
        InetSocketAddress[] list = InetAddressUtil.getSocketAddressList(this.nameServersList, this.serverPort, null);
        for (InetSocketAddress ep : list) {
            this.nameClients.add(new CAJNameClient(this, ep));
        }
        for (CAJNameClient client : this.nameClients) {
            client.connect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeUDPTransport() {
        try {
            InetSocketAddress repeaterLocalAddress = new InetSocketAddress("127.0.0.1", this.repeaterPort);
            BroadcastConnector broadcastConnector = new BroadcastConnector(this);
            ReactorHandler handler = this.broadcastTransport = (BroadcastTransport)broadcastConnector.connect(null, new CAResponseHandler(this), repeaterLocalAddress, (short)13, (short)0);
            if (this.getLeaderFollowersThreadPool() != null) {
                handler = new LeaderFollowersHandler(this.getReactor(), handler, this.getLeaderFollowersThreadPool());
            }
            try {
                DatagramChannel channel = this.broadcastTransport.getChannel();
                channel.socket().setReuseAddress(true);
                channel.socket().bind(new InetSocketAddress(0));
                this.getReactor().register(channel, 1, handler);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
            if (this.addressList != null && this.addressList.length() > 0) {
                InetSocketAddress[] list;
                InetSocketAddress[] appendList = null;
                if (this.autoAddressList) {
                    appendList = this.broadcastTransport.getBroadcastAddresses();
                }
                if ((list = InetAddressUtil.getSocketAddressList(this.addressList, this.serverPort, appendList)) != null && list.length > 0) {
                    this.broadcastTransport.setBroadcastAddresses(list);
                }
            } else if (!this.autoAddressList) {
                this.logger.log(Level.WARNING, "Empty broadcast search address list, all connects will fail.");
                this.broadcastTransport.setBroadcastAddresses(null);
            }
            RepeaterRegistrationTask registrationTask = new RepeaterRegistrationTask(this, repeaterLocalAddress);
            Object object = this.registrationConfirmedCondition;
            synchronized (object) {
                registrationTask.registrationRequest();
                try {
                    if (!this.registrationConfirmed) {
                        this.registrationConfirmedCondition.wait(100L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (!this.registrationConfirmed) {
                registrationTask.runInBackground(1000);
            }
        }
        catch (ConnectionException ce) {
            this.logger.log(Level.SEVERE, "Failed to initialize UDP transport.", ce);
        }
        catch (UnknownHostException uhe) {
            this.logger.log(Level.SEVERE, "Failed to obtain local host address.", uhe);
        }
    }

    @Override
    public synchronized void destroy() throws CAException, IllegalStateException {
        if (this.state == 2) {
            throw new IllegalStateException("Context already destroyed.");
        }
        this.state = 2;
        this.internalDestroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalDestroy() throws CAException {
        if (this.channelSearchManager != null) {
            this.channelSearchManager.cancel();
        }
        for (CAJNameClient client : this.nameClients) {
            client.cancel();
        }
        if (this.timer != null) {
            this.timer.shutDown();
        }
        Object object = this.zeroPendingRequestsCondition;
        synchronized (object) {
            this.zeroPendingRequestsCondition.notifyAll();
        }
        this.destroyAllChannels();
        if (this.reactor != null) {
            this.reactor.shutdown();
        }
        if (this.leaderFollowersThreadPool != null) {
            this.leaderFollowersThreadPool.shutdown();
        }
        if (this.eventDispatcher != null) {
            this.eventDispatcher.dispose();
        }
        object = this.contextMessageListeners;
        synchronized (object) {
            this.contextMessageListeners.clear();
        }
        object = this.contextExceptionListeners;
        synchronized (object) {
            this.contextExceptionListeners.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyAllChannels() {
        Channel[] channelsArray = this.getChannels();
        IntHashMap intHashMap = this.channelsByCID;
        synchronized (intHashMap) {
            this.channelsByCID.clear();
            this.channelsByName.clear();
        }
        for (int i = 0; i < channelsArray.length; ++i) {
            try {
                ((CAJChannel)channelsArray[i]).destroy(true);
                continue;
            }
            catch (Throwable th) {
                this.logger.log(Level.SEVERE, "", th);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Channel createChannel(String name, ConnectionListener l, short priority) throws CAException, IllegalStateException {
        this.checkState();
        if (name == null || name.getBytes().length == 0) {
            throw new IllegalArgumentException("null or empty channel name");
        }
        if (name.getBytes().length > Math.min(1008, 65535)) {
            throw new CAException("name too long");
        }
        if (priority < 0 || priority > 99) {
            throw new IllegalArgumentException("priority out of bounds");
        }
        CAJChannel channel = this.getChannel(name, priority, true);
        if (channel != null) {
            if (l != null) {
                channel.addConnectionListenerAndFireIfConnected(l);
            }
            return channel;
        }
        boolean lockAcquired = this.namedLocker.acquireSynchronizationObject(name, 20000L);
        if (lockAcquired) {
            try {
                channel = this.getChannel(name, priority, true);
                if (channel != null) {
                    if (l != null) {
                        channel.addConnectionListenerAndFireIfConnected(l);
                    }
                    CAJChannel cAJChannel = channel;
                    return cAJChannel;
                }
                int cid = this.generateCID();
                CAJChannel cAJChannel = channel = new CAJChannel(this, cid, name, l, priority);
                return cAJChannel;
            }
            finally {
                this.namedLocker.releaseSynchronizationObject(name);
            }
        }
        throw new CAException("Failed to obtain synchronization lock for '" + name + "', possible deadlock.", null);
    }

    public void destroyChannel(CAJChannel channel, boolean force) throws CAException, IllegalStateException {
        boolean lockAcquired = this.namedLocker.acquireSynchronizationObject(channel.getName(), 20000L);
        if (lockAcquired) {
            try {
                channel.destroyChannel(force);
            }
            catch (IOException ioex) {
                this.logger.log(Level.SEVERE, "Failed to cleanly destroy channel.", ioex);
                throw new CAException("Failed to cleanly destroy channel.", ioex);
            }
            finally {
                this.namedLocker.releaseSynchronizationObject(channel.getName());
            }
        } else {
            throw new CAException("Failed to obtain synchronization lock for '" + channel.getName() + "', possible deadlock.", null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerChannel(CAJChannel channel) {
        IntHashMap intHashMap = this.channelsByCID;
        synchronized (intHashMap) {
            this.channelsByCID.put(channel.getChannelID(), channel);
            if (!this.doNotShareChannels.get()) {
                this.channelsByName.put(this.getUniqueChannelName(channel.getName(), channel.getPriority()), channel);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterChannel(CAJChannel channel) {
        IntHashMap intHashMap = this.channelsByCID;
        synchronized (intHashMap) {
            this.channelsByCID.remove(channel.getChannelID());
            if (!this.doNotShareChannels.get()) {
                this.channelsByName.remove(this.getUniqueChannelName(channel.getName(), channel.getPriority()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CAJChannel getChannel(int channelID) {
        IntHashMap intHashMap = this.channelsByCID;
        synchronized (intHashMap) {
            return (CAJChannel)this.channelsByCID.get(channelID);
        }
    }

    private final String getUniqueChannelName(String name, short priority) {
        return name + '\u0000' + priority;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CAJChannel getChannel(String name, short priority, boolean acquire) {
        if (this.doNotShareChannels.get()) {
            return null;
        }
        Map map = this.channelsByName;
        synchronized (map) {
            CAJChannel channel = (CAJChannel)this.channelsByName.get(this.getUniqueChannelName(name, priority));
            if (channel != null && acquire) {
                channel.acquire();
            }
            return channel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Channel[] getChannels() {
        IntHashMap intHashMap = this.channelsByCID;
        synchronized (intHashMap) {
            Object[] ch = new Channel[this.channelsByCID.size()];
            return (Channel[])this.channelsByCID.toArray(ch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pendIO(double timeout) throws TimeoutException, CAException, IllegalStateException {
        int stillPending;
        this.checkState();
        long time = System.currentTimeMillis();
        this.flushIO();
        long timeToWaitInMS = 0L;
        if (timeout >= 0.0) {
            try {
                Object object = this.zeroPendingRequestsCondition;
                synchronized (object) {
                    if (timeout == 0.0) {
                        while (this.pendingRequestsCount.get() > 0 && this.state != 2) {
                            this.zeroPendingRequestsCondition.wait();
                        }
                    } else {
                        long endTime = time + (long)(timeout * 1000.0);
                        while (this.pendingRequestsCount.get() > 0 && (timeToWaitInMS = endTime - System.currentTimeMillis()) > 0L && this.state != 2) {
                            this.zeroPendingRequestsCondition.wait(timeToWaitInMS);
                        }
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        AtomicInteger atomicInteger = this.sequenceNumberIO;
        synchronized (atomicInteger) {
            this.sequenceNumberIO.incrementAndGet();
            stillPending = this.pendingRequestsCount.getAndSet(0);
        }
        if (stillPending > 0) {
            if (this.state == 2) {
                throw new CAException("context destroyed during pendIO");
            }
            if (timeToWaitInMS <= 0L) {
                throw new TimeoutException("pendIO timed out");
            }
        }
    }

    @Override
    public boolean testIO() throws CAException, IllegalStateException {
        this.checkState();
        return this.pendingRequestsCount.get() == 0;
    }

    @Override
    public void pendEvent(double timeout) throws CAException, IllegalStateException {
        this.checkState();
        long time = System.currentTimeMillis();
        this.flushIO();
        time = System.currentTimeMillis() - time;
        long timeToWaitInMS = (long)(timeout * 1000.0) - time;
        if (timeout == 0.0 || timeToWaitInMS > 0L) {
            try {
                if (timeout == 0.0) {
                    Thread.currentThread().join();
                } else {
                    Thread.sleep(timeToWaitInMS);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    @Override
    public void poll() throws CAException, IllegalStateException {
        this.checkState();
        this.flushIO();
    }

    @Override
    public void flushIO() throws CAException, IllegalStateException {
        this.checkState();
        Transport[] transports = this.transportRegistry.toArray();
        for (int i = 0; i < transports.length; ++i) {
            ((CATransport)transports[i]).flush();
        }
    }

    @Override
    public void attachCurrentThread() throws CAException, IllegalStateException {
        this.checkState();
    }

    @Override
    public void printInfo(PrintStream out) throws IllegalStateException {
        super.printInfo(out);
        out.println("ADDR_LIST : " + this.addressList);
        out.println("AUTO_ADDR_LIST : " + this.autoAddressList);
        if (this.broadcastTransport != null) {
            out.println("AUTO_ADDR_LIST (active): " + Arrays.toString(this.broadcastTransport.getBroadcastAddresses()));
        }
        out.println("NAME_SERVERS : " + this.nameServersList);
        out.println("CONNECTION_TIMEOUT : " + this.connectionTimeout);
        out.println("BEACON_PERIOD : " + this.beaconPeriod);
        out.println("BEACON_SPEEDUP : " + this.beaconSpeedup);
        out.println("BEACON_SLOWDOWN : " + this.beaconSlowdown);
        out.println("ECHO_TIMEOUT : " + this.echoTimeout);
        out.println("REPEATER_PORT : " + this.repeaterPort);
        out.println("SERVER_PORT : " + this.serverPort);
        out.println("MAX_ARRAY_BYTES : " + this.maxArrayBytes);
        out.println("MIN_SEARCH_INTERVAL : " + this.minSearchInterval);
        out.println("MAX_SEARCH_INTERVAL : " + this.maxSearchInterval);
        out.println("EVENT_DISPATCHER: " + this.eventDispatcher);
        out.print("STATE : ");
        switch (this.state) {
            case 0: {
                out.println("NOT_INITIALIZED");
                break;
            }
            case 1: {
                out.println("INITIALIZED");
                break;
            }
            case 2: {
                out.println("DESTROYED");
                break;
            }
            default: {
                out.println("UNKNOWN");
            }
        }
    }

    public boolean isInitialized() {
        return this.state == 1;
    }

    public boolean isDestroyed() {
        return this.state == 2;
    }

    public String getAddressList() {
        return this.addressList;
    }

    public boolean isAutoAddressList() {
        return this.autoAddressList;
    }

    public float getBeaconPeriod() {
        return this.beaconPeriod;
    }

    public float getBeaconSpeedup() {
        return this.beaconSpeedup;
    }

    public float getBeaconSlowdown() {
        return this.beaconSlowdown;
    }

    public long getEchoTimeout() {
        return this.echoTimeout;
    }

    public float getConnectionTimeout() {
        return this.connectionTimeout;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    public int getMaxArrayBytes() {
        return this.maxArrayBytes;
    }

    public int getRepeaterPort() {
        return this.repeaterPort;
    }

    @Override
    public int getServerPort() {
        return this.serverPort;
    }

    @Override
    public int getBroadcastPort() {
        return this.getServerPort();
    }

    public float getMinSearchInterval() {
        return this.minSearchInterval;
    }

    public float getMaxSearchInterval() {
        return this.maxSearchInterval;
    }

    public final EventDispatcher getEventDispatcher() {
        return this.eventDispatcher;
    }

    @Override
    public Reactor getReactor() {
        return this.reactor;
    }

    @Override
    public BroadcastTransport getBroadcastTransport() {
        return this.broadcastTransport;
    }

    @Override
    public CATransportRegistry getTransportRegistry() {
        return this.transportRegistry;
    }

    @Override
    public Timer getTimer() {
        return this.timer;
    }

    public ChannelSearchManager getChannelSearchManager() {
        return this.channelSearchManager;
    }

    @Override
    public CachedByteBufferAllocator getCachedBufferAllocator() {
        return this.cachedBufferAllocator;
    }

    @Override
    public LeaderFollowersThreadPool getLeaderFollowersThreadPool() {
        return this.leaderFollowersThreadPool;
    }

    public boolean isRegistrationConfirmed() {
        return this.registrationConfirmed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void repeaterConfirm(InetSocketAddress responseFrom) {
        this.logger.fine("Repeater " + responseFrom + " confirmed registration.");
        this.registrationConfirmed = true;
        Object object = this.registrationConfirmedCondition;
        synchronized (object) {
            this.registrationConfirmedCondition.notifyAll();
        }
    }

    public void beaconAnomalyNotify() {
        if (this.channelSearchManager != null) {
            this.channelSearchManager.beaconAnomalyNotify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void searchResponse(int cid, int sid, short type, int count, short minorRevision, InetSocketAddress serverAddress) {
        boolean issueCreateRequest;
        CAJChannel channel = this.getChannel(cid);
        if (channel == null) {
            return;
        }
        CAJChannel cAJChannel = channel;
        synchronized (cAJChannel) {
            int seqNo;
            CATransport transport = channel.getTransport();
            if (transport != null && !transport.getRemoteAddress().equals(serverAddress)) {
                this.logger.info("More than one PVs with name '" + channel.getName() + "' detected, additional response from: " + serverAddress);
                return;
            }
            this.channelSearchManager.searchResponse(channel, seqNo, (seqNo = this.lastReceivedSequenceNumber.get()) != 0, System.currentTimeMillis());
            transport = this.getTransport(channel, serverAddress, minorRevision, channel.getPriority());
            if (transport == null) {
                channel.createChannelFailed();
                return;
            }
            issueCreateRequest = channel.createChannel(transport, sid, type, count);
        }
        if (issueCreateRequest) {
            channel.issueCreateChannelRequest();
        }
    }

    public CATransport getTransport(TransportClient client, InetSocketAddress serverAddress, short minorRevision, short priority) {
        try {
            return (CATransport)this.connector.connect(client, new CAResponseHandler(this), serverAddress, minorRevision, priority);
        }
        catch (ConnectionException cex) {
            this.logger.log(Level.SEVERE, "Failed to create transport for: " + serverAddress, cex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int generateCID() {
        IntHashMap intHashMap = this.channelsByCID;
        synchronized (intHashMap) {
            while (this.getChannel(++this.lastCID) != null) {
            }
            this.channelsByCID.put(this.lastCID, null);
            return this.lastCID;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseRequest getResponseRequest(int ioid) {
        IntHashMap intHashMap = this.pendingResponseRequests;
        synchronized (intHashMap) {
            return (ResponseRequest)this.pendingResponseRequests.get(ioid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int registerResponseRequest(ResponseRequest request) {
        IntHashMap intHashMap = this.pendingResponseRequests;
        synchronized (intHashMap) {
            int ioid = this.generateIOID();
            this.pendingResponseRequests.put(ioid, request);
            return ioid;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseRequest unregisterResponseRequest(ResponseRequest request) {
        IntHashMap intHashMap = this.pendingResponseRequests;
        synchronized (intHashMap) {
            return (ResponseRequest)this.pendingResponseRequests.remove(request.getIOID());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int generateIOID() {
        IntHashMap intHashMap = this.pendingResponseRequests;
        synchronized (intHashMap) {
            while (this.pendingResponseRequests.get(++this.lastIOID) != null) {
            }
            this.pendingResponseRequests.put(this.lastIOID, null);
            return this.lastIOID;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int incrementPendingRequests() {
        AtomicInteger atomicInteger = this.sequenceNumberIO;
        synchronized (atomicInteger) {
            this.pendingRequestsCount.incrementAndGet();
            return this.sequenceNumberIO.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decrementPendingRequests(int usedSequenceNumberIO) {
        int count;
        if (usedSequenceNumberIO == this.sequenceNumberIO.get() && (count = this.pendingRequestsCount.decrementAndGet()) == 0) {
            Object object = this.zeroPendingRequestsCondition;
            synchronized (object) {
                this.zeroPendingRequestsCondition.notifyAll();
            }
        }
    }

    public final void setLastReceivedSequenceNumber(int seqNo) {
        this.lastReceivedSequenceNumber.set(seqNo);
    }

    public final int getLastReceivedSequenceNumber(int seqNo) {
        return this.lastReceivedSequenceNumber.get();
    }

    @Override
    public final void invalidateLastReceivedSequence() {
        this.lastReceivedSequenceNumber.set(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CABeaconHandler getBeaconHandler(InetSocketAddress responseFrom) {
        Map map = this.beaconHandlers;
        synchronized (map) {
            CABeaconHandler handler = (CABeaconHandler)this.beaconHandlers.get(responseFrom);
            if (handler == null) {
                handler = new CABeaconHandler(this, responseFrom);
                this.beaconHandlers.put(responseFrom, handler);
            }
            return handler;
        }
    }

    public void modifyUserName(String userName) {
        if (userName == null) {
            throw new NullPointerException("userName == null");
        }
        this.userName = userName;
        Transport[] transports = this.getTransportRegistry().toArray();
        for (int i = 0; i < transports.length; ++i) {
            CATransport transport = (CATransport)transports[i];
            try {
                transport.updateUserName();
                continue;
            }
            catch (Throwable th) {
                this.logger.log(Level.WARNING, "Failed to update username for transport: " + transport.getRemoteAddress(), th);
            }
        }
    }

    @Override
    public String getUserName() {
        return this.userName;
    }
}

