/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.epics.caj;

import com.cosylab.epics.caj.CAJChannel;
import com.cosylab.epics.caj.CAJContext;
import com.cosylab.epics.caj.impl.CATransport;
import com.cosylab.epics.caj.impl.requests.EventAddRequest;
import com.cosylab.epics.caj.impl.requests.EventCancelRequest;
import gov.aps.jca.CAException;
import gov.aps.jca.Channel;
import gov.aps.jca.Context;
import gov.aps.jca.Monitor;
import gov.aps.jca.dbr.DBRType;
import gov.aps.jca.event.MonitorEvent;
import gov.aps.jca.event.MonitorListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class CAJMonitor
extends Monitor
implements MonitorListener {
    protected CAJContext context;
    protected DBRType type;
    protected int count;
    protected CAJChannel channel;
    protected EventAddRequest eventAddRequest = null;
    protected int mask;
    protected ArrayList listeners = new ArrayList();
    protected int subsid;
    protected volatile boolean cleared = false;

    public CAJMonitor(CAJContext context, DBRType type, int count, CAJChannel channel, MonitorListener listener, int mask) throws CAException {
        this.context = context;
        this.type = type;
        this.count = count;
        this.channel = channel;
        this.mask = mask;
        if (listener != null) {
            this.addMonitorListener(listener);
        }
        this.internalConnect();
        channel.registerMonitor(this);
    }

    private void internalConnect() throws CAException {
        try {
            this.eventAddRequest = new EventAddRequest(this.channel, this, this.channel.getTransport(), this.channel.getServerChannelID(), this.type.getValue(), this.count, this.mask);
            this.eventAddRequest.submit();
            this.subsid = this.eventAddRequest.getIOID();
        }
        catch (IOException ioex) {
            throw new CAException("Failed to create monitor.", ioex);
        }
    }

    @Override
    public synchronized void clear() throws CAException {
        if (this.cleared) {
            return;
        }
        this.cleared = true;
        CATransport t = this.channel.getTransport();
        if (t != null) {
            try {
                new EventCancelRequest(t, this.channel.getServerChannelID(), this.subsid, this.type.getValue(), this.count).submit();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.eventAddRequest.cancel();
        this.channel.unregisterMonitor(this);
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    @Override
    public Channel getChannel() {
        return this.channel;
    }

    @Override
    public DBRType getType() {
        return this.type;
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public int getMask() {
        return this.mask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MonitorListener getMonitorListener() {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            if (this.listeners.size() == 0) {
                return null;
            }
            return (MonitorListener)this.listeners.get(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMonitorListener(MonitorListener l) {
        if (l == null) {
            throw new IllegalArgumentException("l == null");
        }
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            if (!this.listeners.contains(l)) {
                this.listeners.add(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMonitorListener(MonitorListener l) {
        if (l == null) {
            throw new IllegalArgumentException("l == null");
        }
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MonitorListener[] getMonitorListeners() {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            MonitorListener[] l = new MonitorListener[this.listeners.size()];
            return this.listeners.toArray(l);
        }
    }

    @Override
    public void monitorChanged(MonitorEvent ev) {
        this.context.getEventDispatcher().dispatch(ev, (List)this.listeners);
    }

    public int getSID() {
        return this.subsid;
    }

    public boolean isCleared() {
        return this.cleared;
    }
}

