/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.epics.caj.impl;

import com.cosylab.epics.caj.CAJContext;
import com.cosylab.epics.caj.impl.CATransport;
import com.cosylab.epics.caj.impl.Transport;
import java.net.InetSocketAddress;
import java.util.logging.Level;

public class CABeaconHandler {
    private CAJContext context;
    private InetSocketAddress responseFrom;
    private long averagePeriod = Long.MIN_VALUE;
    private boolean periodStabilized = false;
    private long lastBeaconSequenceID;
    private long lastBeaconTimeStamp = Long.MIN_VALUE;
    private final long initializationTimeStamp = System.currentTimeMillis();

    public CABeaconHandler(CAJContext context, InetSocketAddress responseFrom) {
        this.context = context;
        this.responseFrom = responseFrom;
        context.getLogger().log(Level.FINE, () -> "CABeaconHandler for " + responseFrom + ": Speedup " + context.getBeaconSpeedup() + ", slowdown " + context.getBeaconSlowdown());
    }

    public void beaconNotify(short remoteTransportRevision, long timestamp, long sequentalID) {
        this.context.getLogger().log(Level.FINE, () -> "Beacon " + timestamp + " [" + sequentalID + "] from " + this.responseFrom + " ...");
        boolean networkChanged = this.updateBeaconPeriod(remoteTransportRevision, timestamp, sequentalID);
        if (networkChanged) {
            this.changedTransport();
        }
    }

    private synchronized boolean updateBeaconPeriod(short remoteTransportRevision, long timestamp, long sequentalID) {
        if (this.lastBeaconTimeStamp == Long.MIN_VALUE) {
            this.context.getLogger().log(Level.INFO, () -> "New server beacon " + this.responseFrom);
            this.context.beaconAnomalyNotify();
            if (remoteTransportRevision >= 10) {
                this.lastBeaconSequenceID = sequentalID;
            }
            this.lastBeaconTimeStamp = timestamp;
            this.beaconArrivalNotify();
            return false;
        }
        if (remoteTransportRevision >= 10) {
            long beaconSeqAdvance = sequentalID >= this.lastBeaconSequenceID ? sequentalID - this.lastBeaconSequenceID : 0xFFFFFFFFL - this.lastBeaconSequenceID + sequentalID;
            this.lastBeaconSequenceID = sequentalID;
            if (beaconSeqAdvance == 0L || beaconSeqAdvance > 0xFFFFFEFFL) {
                return false;
            }
            if (beaconSeqAdvance > 1L && beaconSeqAdvance < 4L) {
                this.lastBeaconTimeStamp = timestamp;
                return false;
            }
        }
        boolean networkChange = false;
        long currentPeriod = timestamp - this.lastBeaconTimeStamp;
        if (this.averagePeriod < 0L) {
            this.averagePeriod = currentPeriod;
            this.beaconArrivalNotify();
        } else {
            if ((float)currentPeriod >= (float)this.averagePeriod * this.context.getBeaconSlowdown()) {
                if ((double)currentPeriod >= (double)this.averagePeriod * 3.25) {
                    this.context.getLogger().log(Level.INFO, () -> "Restored network segment beacon " + this.responseFrom + ", period was " + this.averagePeriod + ", now " + currentPeriod);
                    this.context.beaconAnomalyNotify();
                    networkChange = true;
                } else if (!this.periodStabilized) {
                    this.averagePeriod = currentPeriod;
                    this.beaconArrivalNotify();
                } else {
                    this.context.getLogger().log(Level.INFO, () -> "Delayed beacon " + this.responseFrom + ", period was " + this.averagePeriod + ", now " + currentPeriod);
                    this.context.beaconAnomalyNotify();
                }
            } else if (this.periodStabilized && (float)currentPeriod <= (float)this.averagePeriod * this.context.getBeaconSpeedup()) {
                this.context.getLogger().log(Level.INFO, () -> "Fast 'reboot' beacon " + this.responseFrom + ", period was " + this.averagePeriod + ", now " + currentPeriod);
                this.context.beaconAnomalyNotify();
                networkChange = true;
            } else {
                this.periodStabilized = true;
                this.beaconArrivalNotify();
            }
            if (networkChange) {
                this.periodStabilized = false;
                this.averagePeriod = -1L;
            } else {
                this.averagePeriod = (long)((double)currentPeriod * 0.125 + (double)this.averagePeriod * 0.875);
            }
        }
        this.lastBeaconTimeStamp = timestamp;
        this.context.getLogger().log(Level.FINE, () -> "beacon " + this.responseFrom + " period: " + this.averagePeriod + (this.periodStabilized ? " (stable)" : " (not stable)"));
        return networkChange;
    }

    private void beaconArrivalNotify() {
        Transport[] transports = this.context.getTransportRegistry().get(this.responseFrom);
        if (transports == null) {
            return;
        }
        for (int i = 0; i < transports.length; ++i) {
            ((CATransport)transports[i]).beaconArrivalNotify();
        }
    }

    private void changedTransport() {
        Transport[] transports = this.context.getTransportRegistry().get(this.responseFrom);
        if (transports == null) {
            return;
        }
        for (int i = 0; i < transports.length; ++i) {
            ((CATransport)transports[i]).changedTransport();
        }
    }
}

