/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.epics.caj.impl.reactor.lf;

import com.cosylab.epics.caj.impl.reactor.Reactor;
import com.cosylab.epics.caj.impl.reactor.ReactorHandler;
import com.cosylab.epics.caj.impl.reactor.lf.LeaderFollowersThreadPool;
import java.nio.channels.SelectionKey;

public class LeaderFollowersHandler
implements ReactorHandler,
Runnable {
    protected Reactor reactor;
    protected ReactorHandler handler;
    protected LeaderFollowersThreadPool threadPool;

    public LeaderFollowersHandler(Reactor reactor, ReactorHandler handler, LeaderFollowersThreadPool threadPool) {
        this.reactor = reactor;
        this.handler = handler;
        this.threadPool = threadPool;
    }

    @Override
    public void handleEvent(SelectionKey key) {
        if (!key.isValid()) {
            this.threadPool.promoteLeader(this);
            return;
        }
        this.reactor.disableSelectionKey(key);
        try {
            this.threadPool.promoteLeader(this);
            this.handler.handleEvent(key);
        }
        finally {
            this.reactor.enableSelectionKey(key);
        }
    }

    @Override
    public void run() {
        this.reactor.process();
    }
}

