/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.epics.caj.impl.requests;

import com.cosylab.epics.caj.impl.Request;
import com.cosylab.epics.caj.impl.Transport;
import java.io.IOException;
import java.nio.ByteBuffer;

public abstract class AbstractCARequest
implements Request {
    private static final ByteBuffer EMPTY_MESSAGE = ByteBuffer.allocate(0);
    protected ByteBuffer requestMessage = EMPTY_MESSAGE;
    protected Transport transport;

    public AbstractCARequest(Transport transport) {
        this.transport = transport;
    }

    @Override
    public byte getPriority() {
        return 49;
    }

    @Override
    public ByteBuffer getRequestMessage() {
        if (this.requestMessage == null) {
            this.requestMessage = this.generateRequestMessage();
        }
        return this.requestMessage;
    }

    public ByteBuffer generateRequestMessage() {
        return null;
    }

    @Override
    public void submit() throws IOException {
        this.transport.submit(this);
    }

    public static ByteBuffer insertCAHeader(Transport transport, ByteBuffer buffer, short command, int payloadSize, short dataType, int dataCount, int parameter1, int parameter2) {
        int requiredSize;
        boolean useExtendedHeader;
        boolean bl = useExtendedHeader = payloadSize >= 65535 || dataCount >= 65535;
        if (useExtendedHeader && transport != null && transport.getMinorRevision() < 9) {
            throw new IllegalArgumentException("Out of bounds.");
        }
        int n = requiredSize = useExtendedHeader ? 24 : 16;
        if (buffer == null || buffer.limit() - buffer.position() < requiredSize) {
            buffer = ByteBuffer.allocate(requiredSize);
        }
        if (!useExtendedHeader) {
            buffer.putShort(command);
            buffer.putShort((short)payloadSize);
            buffer.putShort(dataType);
            buffer.putShort((short)dataCount);
            buffer.putInt(parameter1);
            buffer.putInt(parameter2);
        } else {
            buffer.putShort(command);
            buffer.putShort((short)-1);
            buffer.putShort(dataType);
            buffer.putShort((short)0);
            buffer.putInt(parameter1);
            buffer.putInt(parameter2);
            buffer.putInt(payloadSize);
            buffer.putInt(dataCount);
        }
        return buffer;
    }

    public static ByteBuffer alignBuffer(int align, ByteBuffer buffer) {
        int alignedBufferSize = AbstractCARequest.calculateAlignedSize(align, buffer.position());
        if (alignedBufferSize > buffer.capacity()) {
            ByteBuffer nbuffer = ByteBuffer.allocate(alignedBufferSize);
            nbuffer.put(buffer);
            buffer = nbuffer;
        }
        alignedBufferSize -= buffer.position();
        for (int i = 0; i < alignedBufferSize; ++i) {
            buffer.put((byte)0);
        }
        return buffer;
    }

    public static int calculateAlignedSize(int align, int nonAlignedSize) {
        return (nonAlignedSize + align - 1) / align * align;
    }
}

