/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.epics.caj.impl.requests;

import com.cosylab.epics.caj.impl.Transport;
import com.cosylab.epics.caj.impl.requests.AbstractCARequest;
import java.io.IOException;
import java.nio.ByteBuffer;

public class CreateChannelRequest
extends AbstractCARequest {
    protected int cid;

    public CreateChannelRequest(Transport transport, String channelName, int cid) {
        super(transport);
        this.cid = cid;
        if (transport.getMinorRevision() < 4) {
            channelName = null;
        }
        int binaryNameLength = 0;
        if (channelName != null) {
            binaryNameLength = channelName.getBytes().length + 1;
        }
        int alignedMessageSize = CreateChannelRequest.calculateAlignedSize(8, 16 + binaryNameLength);
        this.requestMessage = ByteBuffer.allocate(alignedMessageSize);
        this.requestMessage = CreateChannelRequest.insertCAHeader(transport, this.requestMessage, (short)18, (short)(alignedMessageSize - 16), (short)0, 0, cid, transport.getMinorRevision());
        if (binaryNameLength > 0) {
            this.requestMessage.put(channelName.getBytes());
            this.requestMessage.put((byte)0);
        }
        this.requestMessage = CreateChannelRequest.alignBuffer(8, this.requestMessage);
    }

    @Override
    public void submit() throws IOException {
        super.submit();
    }

    @Override
    public byte getPriority() {
        return 100;
    }
}

