/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.epics.caj.impl.requests;

import com.cosylab.epics.caj.CAJChannel;
import com.cosylab.epics.caj.CAJContext;
import com.cosylab.epics.caj.CAJMonitor;
import com.cosylab.epics.caj.impl.DBRDecoder;
import com.cosylab.epics.caj.impl.NotifyResponseRequest;
import com.cosylab.epics.caj.impl.Transport;
import com.cosylab.epics.caj.impl.requests.AbstractCARequest;
import com.cosylab.epics.caj.impl.requests.SubscriptionUpdateRequest;
import gov.aps.jca.CAStatus;
import gov.aps.jca.dbr.DBR;
import gov.aps.jca.dbr.DBRType;
import gov.aps.jca.event.ContextExceptionEvent;
import gov.aps.jca.event.MonitorEvent;
import java.io.IOException;
import java.nio.ByteBuffer;

public class EventAddRequest
extends AbstractCARequest
implements NotifyResponseRequest {
    protected final CAJContext context;
    protected final int subsid;
    protected final CAJMonitor monitor;
    protected final CAJChannel channel;
    protected byte priority = (byte)49;
    private boolean subscriptionUpdateNeeded = false;
    protected int requestedDataType;
    protected int requestedDataCount;

    public EventAddRequest(CAJChannel channel, CAJMonitor monitor, Transport transport, int sid, int dataType, int dataCount, int mask) {
        super(transport);
        this.channel = channel;
        this.monitor = monitor;
        this.requestedDataType = dataType;
        this.requestedDataCount = dataCount;
        this.context = (CAJContext)channel.getContext();
        this.subsid = this.context.registerResponseRequest(this);
        channel.registerResponseRequest(this);
        if (dataCount < 65535) {
            this.requestMessage = ByteBuffer.allocate(32);
            this.requestMessage = EventAddRequest.insertCAHeader(transport, this.requestMessage, (short)1, 16, (short)dataType, dataCount, sid, this.subsid);
        } else {
            this.requestMessage = ByteBuffer.allocate(40);
            this.requestMessage = EventAddRequest.insertCAHeader(transport, this.requestMessage, (short)1, 16, (short)dataType, dataCount, sid, this.subsid);
        }
        this.requestMessage.putFloat(0.0f);
        this.requestMessage.putFloat(0.0f);
        this.requestMessage.putFloat(0.0f);
        this.requestMessage.putShort((short)mask);
        this.requestMessage.putShort((short)0);
    }

    public void updateSubscription() throws IOException {
        if (this.subscriptionUpdateNeeded) {
            this.subscriptionUpdateNeeded = false;
            new SubscriptionUpdateRequest(this.transport, this.requestMessage.getInt(8), this.requestMessage.getInt(12), this.requestedDataType, this.requestedDataCount).submit();
        }
    }

    @Override
    public void submit() throws IOException {
        if (this.transport == null) {
            return;
        }
        super.submit();
    }

    public void resubscribeSubscription(Transport transport) throws IOException {
        this.transport = transport;
        this.requestMessage.putInt(8, this.channel.getServerChannelID());
        this.priority = (byte)100;
        transport.submit(this);
    }

    @Override
    public int getIOID() {
        return this.subsid;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void response(int status, short dataType, int dataCount, ByteBuffer dataPayloadBuffer) {
        DBR readVal = null;
        CAStatus caStatus = CAStatus.forStatusCode(status);
        if (caStatus == CAStatus.NORMAL) {
            this.subscriptionUpdateNeeded = false;
            if (dataPayloadBuffer.limit() <= 0) {
                this.cancel();
                return;
            }
            readVal = DBRDecoder.getDBR(readVal, dataType, dataCount, dataPayloadBuffer);
        } else {
            this.cancel();
        }
        this.context.getEventDispatcher().dispatch(new MonitorEvent(this.channel, readVal, caStatus), this.monitor);
    }

    @Override
    public synchronized void cancel() {
        this.context.unregisterResponseRequest(this);
        this.channel.unregisterResponseRequest(this);
    }

    @Override
    public void timeout() {
        this.cancel();
        this.context.getEventDispatcher().dispatch(new MonitorEvent(this.channel, null, CAStatus.TIMEOUT), this.monitor);
    }

    @Override
    public void exception(int errorCode, String errorMessage) {
        CAStatus status = CAStatus.forStatusCode(errorCode);
        if (status == CAStatus.CHANDESTROY) {
            this.cancel();
            return;
        }
        if (this.monitor.isCleared()) {
            return;
        }
        this.subscriptionUpdateNeeded = true;
        if (status != CAStatus.DISCONN) {
            if (errorMessage == null && status != null) {
                errorMessage = status.getMessage();
            }
            ContextExceptionEvent cee = new ContextExceptionEvent(this.context, this.channel, DBRType.forValue(this.requestedDataType), this.requestedDataCount, null, errorMessage);
            this.context.notifyException(cee);
        }
    }

    @Override
    public byte getPriority() {
        return this.priority;
    }
}

