/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.epics.caj.util;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class InetAddressUtil {
    public static InetAddress intToIPv4Address(int addr) {
        byte[] a = new byte[]{(byte)(addr >> 24 & 0xFF), (byte)(addr >> 16 & 0xFF), (byte)(addr >> 8 & 0xFF), (byte)(addr & 0xFF)};
        InetAddress res = null;
        try {
            res = InetAddress.getByAddress(a);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return res;
    }

    public static int ipv4AddressToInt(InetAddress addr) {
        if (addr instanceof Inet6Address) {
            throw new IllegalArgumentException("IPv6 address used in IPv4 context");
        }
        byte[] a = addr.getAddress();
        int res = (a[0] & 0xFF) << 24 | (a[1] & 0xFF) << 16 | (a[2] & 0xFF) << 8 | a[3] & 0xFF;
        return res;
    }

    public static InetSocketAddress[] getSocketAddressList(String list, int defaultPort) {
        return InetAddressUtil.getSocketAddressList(list, defaultPort, null);
    }

    public static InetSocketAddress[] getSocketAddressList(String list, int defaultPort, InetSocketAddress[] appendList) {
        ArrayList<InetSocketAddress> al = new ArrayList<InetSocketAddress>();
        StringTokenizer st = new StringTokenizer(list);
        while (st.hasMoreTokens()) {
            int port = defaultPort;
            String address = st.nextToken();
            int pos = address.indexOf(58);
            if (pos >= 0) {
                try {
                    port = Integer.parseInt(address.substring(pos + 1));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                address = address.substring(0, pos);
            }
            al.add(new InetSocketAddress(address, port));
        }
        int appendSize = appendList == null ? 0 : appendList.length;
        InetSocketAddress[] isar = new InetSocketAddress[al.size() + appendSize];
        al.toArray(isar);
        if (appendSize > 0) {
            System.arraycopy(appendList, 0, isar, al.size(), appendSize);
        }
        return isar;
    }
}

