/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.epics.caj.util;

import java.util.concurrent.PriorityBlockingQueue;

public class SearchTimer
extends Thread {
    protected final PriorityBlockingQueue<TimerTask> heap = new PriorityBlockingQueue(64);
    protected final RunLoop runLoop = new RunLoop();
    protected Thread thread;

    public synchronized void executeAfterDelay(long millisecondsToDelay, TimerTask task) {
        long runtime = System.currentTimeMillis() + millisecondsToDelay;
        task.setTimeToRun(millisecondsToDelay, runtime);
        this.heap.offer(task);
        this.restart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void rescheduleAllAfterDelay(long millisecondsToDelay) {
        long timeToRun = System.currentTimeMillis() + millisecondsToDelay;
        PriorityBlockingQueue<TimerTask> priorityBlockingQueue = this.heap;
        synchronized (priorityBlockingQueue) {
            for (TimerTask t : this.heap) {
                t.setTimeToRun(millisecondsToDelay, timeToRun);
            }
        }
        this.restart();
    }

    public static void cancel(Object taskID) {
        ((TimerTask)taskID).setCancelled();
    }

    public synchronized Thread getThread() {
        return this.thread;
    }

    protected synchronized void clearThread() {
        this.thread = null;
    }

    public synchronized void restart() {
        if (this.thread == null) {
            this.thread = new Thread((Runnable)this.runLoop, this.getClass().getName());
            this.thread.start();
        } else {
            this.notify();
        }
    }

    public synchronized void shutDown() {
        this.heap.clear();
        if (this.thread != null) {
            this.thread.interrupt();
        }
        this.thread = null;
    }

    protected synchronized TimerTask nextTask(boolean blockAndExtract, long dt) {
        try {
            while (!Thread.interrupted()) {
                TimerTask task = this.heap.peek();
                if (task == null) {
                    if (!blockAndExtract) {
                        return null;
                    }
                    this.wait();
                    continue;
                }
                long now = System.currentTimeMillis();
                long when = task.getTimeToRun();
                if (when - dt > now) {
                    if (!blockAndExtract) {
                        return null;
                    }
                    this.wait(when - now);
                    continue;
                }
                if (!blockAndExtract) {
                    return task;
                }
                task = this.heap.poll();
                if (task.getCancelled()) continue;
                return task;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return null;
    }

    public boolean hasNext(long dT) {
        return this.nextTask(false, dT) != null;
    }

    protected class RunLoop
    implements Runnable {
        protected RunLoop() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                TimerTask task;
                while ((task = SearchTimer.this.nextTask(true, 0L)) != null) {
                    long millisecondsToDelay = task.timeout();
                    if (millisecondsToDelay <= 0L) continue;
                    long runtime = System.currentTimeMillis() + millisecondsToDelay;
                    task.setTimeToRun(millisecondsToDelay, runtime);
                    SearchTimer.this.heap.offer(task);
                }
            }
            finally {
                SearchTimer.this.clearThread();
            }
        }
    }

    public static abstract class TimerTask
    implements Comparable {
        private long timeToRun;
        private long delay;
        private boolean cancelled = false;

        synchronized void setCancelled() {
            this.cancelled = true;
        }

        synchronized boolean getCancelled() {
            return this.cancelled;
        }

        synchronized void setTimeToRun(long d, long rt) {
            this.delay = d;
            this.timeToRun = rt;
        }

        public synchronized long getTimeToRun() {
            return this.timeToRun;
        }

        public synchronized long getDelay() {
            return this.delay;
        }

        public int compareTo(Object other) {
            long b;
            long a = this.getTimeToRun();
            return a < (b = ((TimerTask)other).getTimeToRun()) ? -1 : (a == b ? 0 : 1);
        }

        public abstract long timeout();
    }
}

