/*
 * Decompiled with CFR 0.152.
 */
package gov.aps.jca;

import gov.aps.jca.CASeverity;
import gov.aps.jca.ValuedEnum;
import java.util.HashMap;
import java.util.Map;

public class CAStatus
extends ValuedEnum {
    private static Map _map = new HashMap();
    public static final CAStatus NORMAL = new CAStatus("NORMAL", 0, CASeverity.SUCCESS, "Normal successful completion");
    public static final CAStatus MAXIOC = new CAStatus("MAXIOC", 1, CASeverity.ERROR, "Maximum simultaneous IOC connections exceeded");
    public static final CAStatus UKNHOST = new CAStatus("UKNHOST", 2, CASeverity.ERROR, "Unknown internet host");
    public static final CAStatus UKNSERV = new CAStatus("UKNSERV", 3, CASeverity.ERROR, "Unknown internet service");
    public static final CAStatus SOCK = new CAStatus("SOCK", 4, CASeverity.ERROR, "Unable to allocate a new socket");
    public static final CAStatus CONN = new CAStatus("CONN", 5, CASeverity.WARNING, "Unable to connect to internet host or service");
    public static final CAStatus ALLOCMEM = new CAStatus("ALLOCMEM", 6, CASeverity.WARNING, "Unable to allocate additional dynamic memory");
    public static final CAStatus UKNCHAN = new CAStatus("UKNCHAN", 7, CASeverity.WARNING, "Unknown IO channel");
    public static final CAStatus UKNFIELD = new CAStatus("UKNFIELD", 8, CASeverity.WARNING, "Record field specified inappropriate for channel specified");
    public static final CAStatus TOLARGE = new CAStatus("TOLARGE", 9, CASeverity.WARNING, "The requested transfer is greater than available memory or EPICS_CA_MAX_ARRAY_BYTES");
    public static final CAStatus TIMEOUT = new CAStatus("TIMEOUT", 10, CASeverity.WARNING, "User specified timeout on IO operation expired");
    public static final CAStatus NOSUPPORT = new CAStatus("NOSUPPORT", 11, CASeverity.WARNING, "Sorry, that feature is planned but not supported at this time");
    public static final CAStatus STRTOBIG = new CAStatus("STRTOBIG", 12, CASeverity.WARNING, "The supplied string is unusually large");
    public static final CAStatus DISCONNCHID = new CAStatus("DISCONNCHID", 13, CASeverity.ERROR, "The request was ignored because the specified channel is disconnected");
    public static final CAStatus BADTYPE = new CAStatus("BADTYPE", 14, CASeverity.ERROR, "The data type specifed is invalid");
    public static final CAStatus CHIDNOTFND = new CAStatus("CHIDNOTFND", 15, CASeverity.INFO, "Remote Channel not found");
    public static final CAStatus CHIDRETRY = new CAStatus("CHIDRETRY", 16, CASeverity.INFO, "Unable to locate all user specified channels");
    public static final CAStatus INTERNAL = new CAStatus("INTERNAL", 17, CASeverity.FATAL, "Channel Access Internal Failure");
    public static final CAStatus DBLCLFAIL = new CAStatus("DBLCLFAIL", 18, CASeverity.WARNING, "The requested local DB operation failed");
    public static final CAStatus GETFAIL = new CAStatus("GETFAIL", 19, CASeverity.WARNING, "Could not perform a database value get for that channel");
    public static final CAStatus PUTFAIL = new CAStatus("PUTFAIL", 20, CASeverity.WARNING, "Could not perform a database value put for that channel");
    public static final CAStatus ADDFAIL = new CAStatus("ADDFAIL", 21, CASeverity.WARNING, "Could not perform a database monitor add for that channel");
    public static final CAStatus BADCOUNT = new CAStatus("BADCOUNT", 22, CASeverity.WARNING, "Count requested inappropriate for that channel");
    public static final CAStatus BADSTR = new CAStatus("BADSTR", 23, CASeverity.ERROR, "The supplied string has improper format");
    public static final CAStatus DISCONN = new CAStatus("DISCONN", 24, CASeverity.WARNING, "Virtual circuit disconnect");
    public static final CAStatus DBLCHNL = new CAStatus("DBLCHNL", 25, CASeverity.WARNING, "Identical process variable name on multiple servers");
    public static final CAStatus EVDISALLOW = new CAStatus("EVDISALLOW", 26, CASeverity.ERROR, "The CA routine called is inappropriate for use within an event handler");
    public static final CAStatus BUILDGET = new CAStatus("BUILDGET", 27, CASeverity.WARNING, "Database value get for that channel failed during channel search");
    public static final CAStatus NEEDSFP = new CAStatus("NEEDSFP", 28, CASeverity.WARNING, "Unable to initialize without the vxWorks VX_FP_TASK task option set");
    public static final CAStatus OVEVFAIL = new CAStatus("OVEVFAIL", 29, CASeverity.WARNING, "Event queue overflow has prevented first pass event after event add");
    public static final CAStatus BADMONID = new CAStatus("BADMONID", 30, CASeverity.ERROR, "bad monitor subscription identifier");
    public static final CAStatus NEWADDR = new CAStatus("NEWADDR", 31, CASeverity.WARNING, "Remote channel has new network address");
    public static final CAStatus NEWCONN = new CAStatus("NEWCONN", 32, CASeverity.INFO, "New or resumed network connection");
    public static final CAStatus NOCACTX = new CAStatus("NOCACTX", 33, CASeverity.WARNING, "Specified task isnt a member of a CA context");
    public static final CAStatus DEFUNCT = new CAStatus("DEFUNCT", 34, CASeverity.FATAL, "Attempt to use defunct CA feature failed");
    public static final CAStatus EMPTYSTR = new CAStatus("EMPTYSTR", 35, CASeverity.WARNING, "The supplied string is empty");
    public static final CAStatus NOREPEATER = new CAStatus("NOREPEATER", 36, CASeverity.WARNING, "Unable to spawn the CA repeater thread- auto reconnect will fail");
    public static final CAStatus NOCHANMSG = new CAStatus("NOCHANMSG", 37, CASeverity.WARNING, "No channel id match for search reply- search reply ignored");
    public static final CAStatus DLCKREST = new CAStatus("DLCKREST", 38, CASeverity.WARNING, "Reseting dead connection- will try to reconnect");
    public static final CAStatus SERVBEHIND = new CAStatus("SERVBEHIND", 39, CASeverity.WARNING, "Server (IOC) has fallen behind or is not responding- still waiting");
    public static final CAStatus NOCAST = new CAStatus("NOCAST", 40, CASeverity.WARNING, "No internet interface with broadcast available");
    public static final CAStatus BADMASK = new CAStatus("BADMASK", 41, CASeverity.ERROR, "The monitor selection mask supplied is empty or inappropriate");
    public static final CAStatus IODONE = new CAStatus("IODONE", 42, CASeverity.INFO, "IO operations have completed");
    public static final CAStatus IOINPROGESS = new CAStatus("IOINPROGESS", 43, CASeverity.INFO, "IO operations are in progress");
    public static final CAStatus BADSYNCGRP = new CAStatus("BADSYNCGRP", 44, CASeverity.ERROR, "Invalid synchronous group identifier");
    public static final CAStatus PUTCBINPROG = new CAStatus("PUTCBINPROG", 45, CASeverity.ERROR, "Put callback timed out");
    public static final CAStatus NORDACCESS = new CAStatus("NORDACCESS", 46, CASeverity.WARNING, "Read access denied");
    public static final CAStatus NOWTACCESS = new CAStatus("NOWTACCESS", 47, CASeverity.WARNING, "Write access denied");
    public static final CAStatus ANACHRONISM = new CAStatus("ANACHRONISM", 48, CASeverity.ERROR, "Sorry, that anachronistic feature of CA is no longer supported");
    public static final CAStatus NOSEARCHADDR = new CAStatus("NOSEARCHADDR", 49, CASeverity.WARNING, "The search/beacon request address list was empty after initialization");
    public static final CAStatus NOCONVERT = new CAStatus("NOCONVERT", 50, CASeverity.WARNING, "Data conversion between client's type and the server's type failed");
    public static final CAStatus BADCHID = new CAStatus("BADCHID", 51, CASeverity.ERROR, "Invalid channel identifier");
    public static final CAStatus BADFUNCPTR = new CAStatus("BADFUNCPTR", 52, CASeverity.ERROR, "Invalid function pointer");
    public static final CAStatus ISATTACHED = new CAStatus("ISATTACHED", 53, CASeverity.WARNING, "Thread is already attached to a client context");
    public static final CAStatus UNAVAILINSERV = new CAStatus("UNAVAILINSERV", 54, CASeverity.WARNING, "No support in service");
    public static final CAStatus CHANDESTROY = new CAStatus("CHANDESTROY", 55, CASeverity.WARNING, "User destroyed channel");
    public static final CAStatus BADPRIORITY = new CAStatus("BADPRIORITY", 56, CASeverity.ERROR, "Priority out of range");
    public static final CAStatus NOTTHREADED = new CAStatus("NOTTHREADED", 57, CASeverity.ERROR, "Preemptive callback not enabled - additional threads may not join");
    public static final CAStatus ARRAY16KCLIENT = new CAStatus("ARRAY16KCLIENT", 58, CASeverity.WARNING, "Client's protocol revision does not support transfers exceeding 16k bytes");
    public static final CAStatus CONNSEQTMO = new CAStatus("CONNSEQTMO", 59, CASeverity.WARNING, "Virtual circuit connection sequence aborted");
    public static final CAStatus UNRESPTMO = new CAStatus("UNRESPTMO", 60, CASeverity.WARNING, "Virtual circuit connection unresponsive");
    static CAStatus[] _cachedTypesByValue;
    private CASeverity _severity;
    private String _msg;
    public static final int CA_M_MSG_NO = 65528;
    public static final int CA_M_SEVERITY = 7;
    public static final int CA_M_LEVEL = 3;
    public static final int CA_M_SUCCESS = 1;
    public static final int CA_M_ERROR = 2;
    public static final int CA_M_SEVERE = 4;
    public static final int CA_S_MSG_NO = 13;
    public static final int CA_S_SEVERITY = 3;
    public static final int CA_V_MSG_NO = 3;
    public static final int CA_V_SEVERITY = 0;
    public static final int CA_V_SUCCESS = 0;

    protected CAStatus(String name, int value, CASeverity severity, String msg) {
        super(name, value, _map);
        this._severity = severity;
        this._msg = msg;
    }

    public boolean isSuccessful() {
        return this._severity.isSuccessful();
    }

    public boolean isError() {
        return this._severity.isError();
    }

    public boolean isFatal() {
        return this._severity.isFatal();
    }

    public CASeverity getSeverity() {
        return this._severity;
    }

    public String getMessage() {
        return this._msg;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "[" + this.getName() + "=" + this.getValue() + "," + this._severity.getName() + "=" + this._severity.getValue() + "]=" + this.getMessage();
    }

    public static CAStatus forName(String name) {
        return (CAStatus)_map.get(name);
    }

    public static final CAStatus forValue(int value) {
        if (value >= 0 && value < _cachedTypesByValue.length) {
            return _cachedTypesByValue[value];
        }
        return null;
    }

    public final int getStatusCode() {
        return this.getValue() << 3 & 0xFFF8 | this.getSeverity().getValue() << 0 & 7;
    }

    public static final CAStatus forStatusCode(int value) {
        return CAStatus.forValue((value & 0xFFF8) >> 3);
    }

    static {
        int maxValue = 0;
        for (CAStatus t : _map.values()) {
            if (t.getValue() <= maxValue) continue;
            maxValue = t.getValue();
        }
        _cachedTypesByValue = new CAStatus[maxValue + 1];
        for (CAStatus t : _map.values()) {
            if (t.getValue() < 0) continue;
            CAStatus._cachedTypesByValue[t.getValue()] = t;
        }
    }
}

