/*
 * Decompiled with CFR 0.152.
 */
package gov.aps.jca.dbr;

import gov.aps.jca.CAStatus;
import gov.aps.jca.CAStatusException;
import gov.aps.jca.dbr.DBR;
import gov.aps.jca.dbr.DBRFactory;
import gov.aps.jca.dbr.DBRType;
import gov.aps.jca.dbr.DBR_Byte;
import gov.aps.jca.dbr.DBR_Double;
import gov.aps.jca.dbr.DBR_Enum;
import gov.aps.jca.dbr.DBR_Float;
import gov.aps.jca.dbr.DBR_Int;
import gov.aps.jca.dbr.DBR_Short;
import gov.aps.jca.dbr.STRING;

public class DBR_String
extends DBR
implements STRING {
    public static final DBRType TYPE = new DBRType("DBR_STRING", 0, DBR_String.class);

    public DBR_String() {
        this(1);
    }

    public DBR_String(int count) {
        this(new String[count]);
    }

    public DBR_String(byte[] value) {
        this(new String(value));
    }

    public DBR_String(String value) {
        this(new String[]{value});
    }

    public DBR_String(char[] value) {
        this(new String(value));
    }

    public DBR_String(String[] value) {
        super(value);
    }

    @Override
    public DBRType getType() {
        return TYPE;
    }

    @Override
    public String[] getStringValue() {
        return (String[])this.getValue();
    }

    @Override
    public DBR convert(DBRType convertType) throws CAStatusException {
        return this.convert(convertType, null);
    }

    @Override
    public DBR convert(DBRType convertType, Object params) throws CAStatusException {
        DBR dbr;
        block20: {
            if (convertType.isSTRING() && convertType.getValue() <= this.getType().getValue()) {
                return this;
            }
            String[] fromValue = this.getStringValue();
            dbr = DBRFactory.create(convertType, this._count);
            try {
                if (convertType.isSTRING()) {
                    String[] toValue = ((DBR_String)dbr).getStringValue();
                    for (int i = 0; i < this._count; ++i) {
                        toValue[i] = String.valueOf(fromValue[i]);
                    }
                    break block20;
                }
                if (convertType.isSHORT()) {
                    short[] toValue = ((DBR_Short)dbr).getShortValue();
                    for (int i = 0; i < this._count; ++i) {
                        toValue[i] = Short.parseShort(fromValue[i]);
                    }
                    break block20;
                }
                if (convertType.isFLOAT()) {
                    float[] toValue = ((DBR_Float)dbr).getFloatValue();
                    for (int i = 0; i < this._count; ++i) {
                        toValue[i] = Float.parseFloat(fromValue[i]);
                    }
                    break block20;
                }
                if (convertType.isENUM()) {
                    short[] toValue = ((DBR_Enum)dbr).getEnumValue();
                    String[] labels = (String[])params;
                    if (labels == null) {
                        throw new CAStatusException(CAStatus.NOCONVERT, "no labels provided");
                    }
                    for (int i = 0; i < this._count; ++i) {
                        short pos;
                        for (pos = 0; !(pos >= (short)labels.length || labels[pos] != null && labels[pos].equals(fromValue[i])); pos = (short)(pos + 1)) {
                        }
                        if (pos >= labels.length) {
                            throw new CAStatusException(CAStatus.NOCONVERT, "'" + fromValue[i] + "' is not a valid choice");
                        }
                        toValue[i] = pos;
                    }
                    break block20;
                }
                if (convertType.isBYTE()) {
                    byte[] toValue = ((DBR_Byte)dbr).getByteValue();
                    for (int i = 0; i < this._count; ++i) {
                        toValue[i] = Byte.parseByte(fromValue[i]);
                    }
                    break block20;
                }
                if (convertType.isINT()) {
                    int[] toValue = ((DBR_Int)dbr).getIntValue();
                    for (int i = 0; i < this._count; ++i) {
                        toValue[i] = Integer.parseInt(fromValue[i]);
                    }
                    break block20;
                }
                if (convertType.isDOUBLE()) {
                    double[] toValue = ((DBR_Double)dbr).getDoubleValue();
                    for (int i = 0; i < this._count; ++i) {
                        toValue[i] = Double.parseDouble(fromValue[i]);
                    }
                    break block20;
                }
                throw new CAStatusException(CAStatus.NOCONVERT, "converstion not supported");
            }
            catch (NumberFormatException nfr) {
                throw new CAStatusException(CAStatus.NOCONVERT);
            }
        }
        return dbr;
    }
}

