/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.sample;

import java.util.List;
import org.epics.pvmanager.ExceptionHandler;
import org.epics.pvmanager.ExpressionLanguage;
import org.epics.pvmanager.PV;
import org.epics.pvmanager.PVManager;
import org.epics.pvmanager.PVReader;
import org.epics.pvmanager.PVReaderEvent;
import org.epics.pvmanager.PVReaderListener;
import org.epics.pvmanager.PVWriter;
import org.epics.pvmanager.PVWriterEvent;
import org.epics.pvmanager.PVWriterListener;
import org.epics.pvmanager.TimeoutException;
import org.epics.pvmanager.expression.DesiredRateExpression;
import org.epics.pvmanager.expression.SourceRateExpression;
import org.epics.pvmanager.expression.SourceRateReadWriteExpression;
import org.epics.pvmanager.expression.WriteExpression;
import org.epics.util.time.TimeDuration;

public class BasicExamples {
    public void b1_readLatestValue() {
        PVReader pvReader = PVManager.read((SourceRateExpression)ExpressionLanguage.channel((String)"channelName")).readListener((PVReaderListener)new PVReaderListener<Object>(){

            public void pvChanged(PVReaderEvent<Object> event) {
                Object newValue = event.getPvReader().getValue();
                System.out.println(newValue);
            }
        }).maxRate(TimeDuration.ofMillis((int)100));
        pvReader.close();
    }

    public void b2_readAllValues() {
        PVReader pvReader = PVManager.read((DesiredRateExpression)ExpressionLanguage.newValuesOf((SourceRateExpression)ExpressionLanguage.channel((String)"channelName"))).readListener((PVReaderListener)new PVReaderListener<List<Object>>(){

            public void pvChanged(PVReaderEvent<List<Object>> event) {
                for (Object newValue : (List)event.getPvReader().getValue()) {
                    System.out.println(newValue);
                }
            }
        }).maxRate(TimeDuration.ofMillis((int)100));
        pvReader.close();
    }

    public void b3_asynchronousWrite() {
        PVWriter pvWriter = PVManager.write((WriteExpression)ExpressionLanguage.channel((String)"channelName")).writeListener((PVWriterListener)new PVWriterListener<Object>(){

            public void pvChanged(PVWriterEvent<Object> event) {
                if (event.isWriteSucceeded()) {
                    System.out.println("Write finished");
                }
            }
        }).async();
        pvWriter.write((Object)"New value");
        pvWriter.close();
    }

    public void b4_synchronousWrite() {
        PVWriter pvWriter = PVManager.write((WriteExpression)ExpressionLanguage.channel((String)"channelName")).sync();
        pvWriter.write((Object)"New value");
        System.out.println("Write finished");
        pvWriter.close();
    }

    public void b5_readAndWrite() {
        PV pv = PVManager.readAndWrite((SourceRateReadWriteExpression)ExpressionLanguage.channel((String)"channelName")).readListener((PVReaderListener)new PVReaderListener<Object>(){

            public void pvChanged(PVReaderEvent<Object> event) {
                Object newValue = event.getPvReader().getValue();
                System.out.println(newValue);
            }
        }).asynchWriteAndMaxReadRate(TimeDuration.ofMillis((int)10));
        pv.write((Object)"New value");
        pv.close();
    }

    public void b6_handlingErrorsOnNotification() {
        PVReader pvReader = PVManager.read((SourceRateExpression)ExpressionLanguage.channel((String)"channelName")).readListener((PVReaderListener)new PVReaderListener<Object>(){

            public void pvChanged(PVReaderEvent<Object> event) {
                Exception ex = event.getPvReader().lastException();
                if (event.getPvReader().lastException() == null) {
                    // empty if block
                }
            }
        }).maxRate(TimeDuration.ofMillis((int)100));
    }

    public void b7_logAllErrors() {
        PVReader pvReader = PVManager.read((SourceRateExpression)ExpressionLanguage.channel((String)"channelName")).routeExceptionsTo(new ExceptionHandler(){

            public void handleException(Exception ex) {
                System.out.println("Error: " + ex.getMessage());
            }
        }).maxRate(TimeDuration.ofMillis((int)100));
    }

    public void b8_readTimeout() {
        PVReader pvReader = PVManager.read((SourceRateExpression)ExpressionLanguage.channel((String)"channelName")).timeout(TimeDuration.ofSeconds((double)5.0)).readListener((PVReaderListener)new PVReaderListener<Object>(){

            public void pvChanged(PVReaderEvent<Object> event) {
                Exception ex = event.getPvReader().lastException();
                if (ex instanceof TimeoutException) {
                    System.out.println("Didn't connected after 5 seconds");
                }
            }
        }).maxRate(TimeDuration.ofMillis((int)100));
    }
}

