/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.sample;

import gov.aps.jca.Context;
import java.util.concurrent.Executor;
import org.epics.pvmanager.CompositeDataSource;
import org.epics.pvmanager.DataSource;
import org.epics.pvmanager.ExpressionLanguage;
import org.epics.pvmanager.PVManager;
import org.epics.pvmanager.PVReader;
import org.epics.pvmanager.expression.SourceRateExpression;
import org.epics.pvmanager.jca.JCADataSource;
import org.epics.pvmanager.jca.JCADataSourceBuilder;
import org.epics.pvmanager.sim.SimulationDataSource;
import org.epics.pvmanager.util.Executors;
import org.epics.util.time.TimeDuration;

public class ConfigurationExamples {
    public void e1_pvManagerInCSS() {
        PVReader pvReader = PVManager.read((SourceRateExpression)ExpressionLanguage.channel((String)"test")).notifyOn(ConfigurationExamples.swtThread()).maxRate(TimeDuration.ofMillis((int)100));
    }

    public void e2_pvManagerInSwing() {
        PVReader pvReader = PVManager.read((SourceRateExpression)ExpressionLanguage.channel((String)"test")).notifyOn(Executors.swingEDT()).maxRate(TimeDuration.ofMillis((int)100));
        PVManager.setDefaultNotificationExecutor((Executor)Executors.swingEDT());
    }

    public void e3_configuringJcaAsDefaultDataSource() {
        PVManager.setDefaultDataSource((DataSource)new JCADataSource());
        Context jcaContext = null;
        PVManager.setDefaultDataSource((DataSource)new JCADataSourceBuilder().monitorMask(5).jcaContext(jcaContext).build());
    }

    public void e4_configuringMultipleDataSources() {
        CompositeDataSource composite = new CompositeDataSource();
        composite.putDataSource("ca", (DataSource)new JCADataSource());
        composite.putDataSource("sim", (DataSource)new SimulationDataSource());
        composite.setDefaultDataSource("ca");
        PVManager.setDefaultDataSource((DataSource)composite);
    }

    public static Executor swtThread() {
        return null;
    }
}

