/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.sample;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.epics.pvmanager.PVManager;
import org.epics.pvmanager.PVReader;
import org.epics.pvmanager.PVReaderEvent;
import org.epics.pvmanager.PVReaderListener;
import org.epics.pvmanager.expression.DesiredRateExpression;
import org.epics.pvmanager.expression.SourceRateExpressionList;
import org.epics.pvmanager.extra.ColorScheme;
import org.epics.pvmanager.extra.WaterfallPlot;
import org.epics.pvmanager.extra.WaterfallPlotParameters;
import org.epics.pvmanager.sample.ImagePanel;
import org.epics.pvmanager.sample.SetupUtil;
import org.epics.pvmanager.util.Executors;
import org.epics.pvmanager.vtype.ExpressionLanguage;
import org.epics.util.time.TimeDuration;
import org.epics.vtype.VImage;
import org.epics.vtype.ValueUtil;

public class MockWaterfallScalarsPlot
extends JFrame {
    private PVReader<VImage> pv;
    private WaterfallPlot plot;
    final BufferedImage finalBuffer = new BufferedImage(100, 100, 5);
    private JCheckBox adaptiveRangeField;
    private JButton goButton;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JTextField lastError;
    private JSpinner pixelDurationField;
    private ImagePanel plotView;
    private JEditorPane pvNamesField;
    private JCheckBox scrollDownField;

    public MockWaterfallScalarsPlot() {
        this.initComponents();
        WaterfallPlotParameters defaults = WaterfallPlotParameters.defaults();
        this.adaptiveRangeField.setSelected(defaults.isAdaptiveRange());
        this.scrollDownField.setSelected(defaults.isScrollDown());
        this.pixelDurationField.setValue(defaults.getPixelDuration().getNanoSec() / 1000000);
        this.plotView.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (MockWaterfallScalarsPlot.this.plot != null) {
                    MockWaterfallScalarsPlot.this.plot.with(new WaterfallPlotParameters[]{WaterfallPlotParameters.height((int)MockWaterfallScalarsPlot.this.plotView.getHeight())});
                }
            }
        });
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.lastError = new JTextField();
        this.jSeparator1 = new JSeparator();
        this.adaptiveRangeField = new JCheckBox();
        this.jLabel3 = new JLabel();
        this.pixelDurationField = new JSpinner();
        this.scrollDownField = new JCheckBox();
        this.plotView = new ImagePanel();
        this.jScrollPane1 = new JScrollPane();
        this.pvNamesField = new JEditorPane();
        this.goButton = new JButton();
        this.setDefaultCloseOperation(3);
        this.jLabel1.setText("PV Names:");
        this.lastError.setEditable(false);
        this.adaptiveRangeField.setText("Adaptive range");
        this.adaptiveRangeField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MockWaterfallScalarsPlot.this.adaptiveRangeFieldActionPerformed(evt);
            }
        });
        this.jLabel3.setText("ms per pixel:");
        this.pixelDurationField.setModel(new SpinnerNumberModel((Number)100, Integer.valueOf(1), null, (Number)1));
        this.pixelDurationField.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                MockWaterfallScalarsPlot.this.pixelDurationFieldStateChanged(evt);
            }
        });
        this.scrollDownField.setSelected(true);
        this.scrollDownField.setText("Latest on top");
        this.scrollDownField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MockWaterfallScalarsPlot.this.scrollDownFieldActionPerformed(evt);
            }
        });
        GroupLayout plotViewLayout = new GroupLayout(this.plotView);
        this.plotView.setLayout(plotViewLayout);
        plotViewLayout.setHorizontalGroup(plotViewLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 474, Short.MAX_VALUE));
        plotViewLayout.setVerticalGroup(plotViewLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 279, Short.MAX_VALUE));
        this.pvNamesField.setText("sim://ramp(0,10,1,0.1)\nsim://ramp(0,10,1,0.2)\nsim://ramp(0,10,1,0.5)\nsim://ramp(0,10,1,1)\n");
        this.jScrollPane1.setViewportView(this.pvNamesField);
        this.goButton.setText("Go");
        this.goButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MockWaterfallScalarsPlot.this.goButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pixelDurationField, -2, 98, -2)).addComponent(this.plotView, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.goButton, 0, 0, Short.MAX_VALUE).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 404, Short.MAX_VALUE)).addComponent(this.lastError, -1, 474, Short.MAX_VALUE)).addContainerGap()).addComponent(this.jSeparator1, GroupLayout.Alignment.TRAILING, -1, 498, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.adaptiveRangeField).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.scrollDownField).addContainerGap(268, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.goButton)).addComponent(this.jScrollPane1, -2, 103, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.pixelDurationField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.adaptiveRangeField).addComponent(this.scrollDownField)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.plotView, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lastError, -2, -1, -2).addContainerGap()));
        this.pack();
    }

    private void pixelDurationFieldStateChanged(ChangeEvent evt) {
        if (this.plot != null) {
            this.plot.with(new WaterfallPlotParameters[]{WaterfallPlotParameters.pixelDuration((TimeDuration)TimeDuration.ofMillis((int)((Number)this.pixelDurationField.getValue()).intValue()))});
        }
    }

    private void scrollDownFieldActionPerformed(ActionEvent evt) {
        if (this.plot != null) {
            this.plot.with(new WaterfallPlotParameters[]{WaterfallPlotParameters.scrollDown((boolean)this.scrollDownField.isSelected())});
        }
    }

    private void adaptiveRangeFieldActionPerformed(ActionEvent evt) {
        if (this.plot != null) {
            this.plot.with(new WaterfallPlotParameters[]{WaterfallPlotParameters.adaptiveRange((boolean)this.adaptiveRangeField.isSelected())});
        }
    }

    private void goButtonActionPerformed(ActionEvent evt) {
        if (this.pv != null) {
            this.pv.close();
        }
        String[] tokens = this.pvNamesField.getText().split("\n");
        ArrayList<String> names = new ArrayList<String>();
        for (String token : tokens) {
            if (token.trim().isEmpty()) continue;
            names.add(token.trim());
        }
        this.plot = org.epics.pvmanager.extra.ExpressionLanguage.waterfallPlotOf((SourceRateExpressionList)ExpressionLanguage.vNumbers(names)).with(new WaterfallPlotParameters[]{WaterfallPlotParameters.colorScheme((ColorScheme)ColorScheme.singleRangeGradient((Color)Color.BLACK, (Color)Color.WHITE, (Color)this.getBackground())), WaterfallPlotParameters.backgroundColor((int)this.getBackground().getRGB()), WaterfallPlotParameters.adaptiveRange((boolean)this.adaptiveRangeField.isSelected()), WaterfallPlotParameters.scrollDown((boolean)this.scrollDownField.isSelected()), WaterfallPlotParameters.height((int)this.plotView.getHeight()), WaterfallPlotParameters.pixelDuration((TimeDuration)TimeDuration.ofMillis((int)((Number)this.pixelDurationField.getValue()).intValue()))});
        this.pv = PVManager.read((DesiredRateExpression)this.plot).readListener((PVReaderListener)new PVReaderListener<VImage>(){

            public void pvChanged(PVReaderEvent<VImage> event) {
                MockWaterfallScalarsPlot.this.setLastError(MockWaterfallScalarsPlot.this.pv.lastException());
                if (MockWaterfallScalarsPlot.this.pv.getValue() != null) {
                    BufferedImage image = ValueUtil.toImage((VImage)((VImage)MockWaterfallScalarsPlot.this.pv.getValue()));
                    MockWaterfallScalarsPlot.this.plotView.setImage(image);
                }
            }
        }).notifyOn(Executors.swingEDT()).maxRate(TimeDuration.ofHertz((double)50.0));
    }

    private void setLastError(Exception ex) {
        if (ex != null) {
            this.lastError.setText(ex.getMessage());
            Logger.getLogger(MockWaterfallScalarsPlot.class.getName()).log(Level.WARNING, "Error", ex);
        } else {
            this.lastError.setText("");
        }
    }

    public static void main(String[] args) {
        SetupUtil.defaultCASetupForSwing();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new MockWaterfallScalarsPlot().setVisible(true);
            }
        });
    }
}

