/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.sample;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.epics.pvmanager.PVManager;
import org.epics.pvmanager.PVReader;
import org.epics.pvmanager.PVReaderEvent;
import org.epics.pvmanager.PVReaderListener;
import org.epics.pvmanager.expression.SourceRateExpression;
import org.epics.pvmanager.sample.SetupUtil;
import org.epics.pvmanager.vtype.ExpressionLanguage;
import org.epics.util.time.TimeDuration;
import org.epics.vtype.VType;

public class MultiplePVLoadTest {
    private static List<PVReader<VType>> readers = new ArrayList<PVReader<VType>>();
    private static final AtomicInteger counter = new AtomicInteger();

    public static void main(String[] args) throws InterruptedException {
        int nPvs = 5000;
        SetupUtil.defaultCASetup();
        for (int i = 0; i < nPvs; ++i) {
            PVReader reader = PVManager.read((SourceRateExpression)ExpressionLanguage.vType((String)"sim://noise")).readListener((PVReaderListener)new PVReaderListener<VType>(){

                public void pvChanged(PVReaderEvent<VType> event) {
                    counter.incrementAndGet();
                }
            }).maxRate(TimeDuration.ofHertz((double)50.0));
            readers.add((PVReader<VType>)reader);
        }
        Thread.sleep(60000L);
        for (PVReader<VType> pVReader : readers) {
            pVReader.close();
        }
    }
}

