/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.sample;

import java.util.List;
import org.epics.pvmanager.DataSource;
import org.epics.pvmanager.ExpressionLanguage;
import org.epics.pvmanager.PVManager;
import org.epics.pvmanager.PVReader;
import org.epics.pvmanager.PVReaderEvent;
import org.epics.pvmanager.PVReaderListener;
import org.epics.pvmanager.expression.DesiredRateExpression;
import org.epics.pvmanager.expression.SourceRateExpression;
import org.epics.pvmanager.sim.SimulationDataSource;
import org.epics.util.time.TimeDuration;
import org.epics.vtype.VNumber;

public class PausePv {
    public static void main(String[] args) throws Exception {
        PVManager.setDefaultDataSource((DataSource)new SimulationDataSource());
        System.out.println("Note that events cannot be stopped while they are in-flight.");
        System.out.println("Therefore you may see one event arriving after the pause or after the close.");
        System.out.println("Starting pv");
        PVReader reader = PVManager.read((DesiredRateExpression)ExpressionLanguage.newValuesOf((SourceRateExpression)org.epics.pvmanager.vtype.ExpressionLanguage.vNumber((String)"ramp()"))).readListener((PVReaderListener)new PVReaderListener<List<VNumber>>(){

            public void pvChanged(PVReaderEvent<List<VNumber>> event) {
                if (event.isValueChanged()) {
                    System.out.println("... values are " + event.getPvReader().getValue());
                }
            }
        }).maxRate(TimeDuration.ofMillis((int)50));
        Thread.sleep(2000L);
        System.out.println("Pausing for 3 seconds");
        reader.setPaused(true);
        Thread.sleep(3000L);
        System.out.println("Unpausing...");
        reader.setPaused(false);
        Thread.sleep(3000L);
        System.out.println("Closing...");
        reader.close();
        PVManager.getDefaultDataSource().close();
        System.out.println("Done");
    }
}

