/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.sample;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.concurrent.Executor;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import org.epics.pvmanager.DataSource;
import org.epics.pvmanager.PVManager;
import org.epics.pvmanager.PVReader;
import org.epics.pvmanager.PVReaderEvent;
import org.epics.pvmanager.PVReaderListener;
import org.epics.pvmanager.expression.SourceRateExpression;
import org.epics.pvmanager.sim.SimulationDataSource;
import org.epics.pvmanager.util.Executors;
import org.epics.pvmanager.vtype.ExpressionLanguage;
import org.epics.util.time.TimeDuration;
import org.epics.util.time.Timestamp;
import org.epics.vtype.VDouble;

public class ReportRateFrame
extends JFrame {
    private PVReader<VDouble> pv;
    private Timestamp overallTimestamp;
    private int overallCounter = 0;
    private int lastPeriodCounter;
    private Timestamp lastPeriodTimestamp;
    private final TimeDuration measureInterval = TimeDuration.ofSeconds((double)2.0);
    private JLabel avgRateLabel;
    private JButton createPVButton;
    private JLabel currentRateLabel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel6;
    private JSpinner scanRateSpinner;
    private JSpinner updateRateSpinner;
    private JLabel valueLabel;

    public ReportRateFrame() {
        PVManager.setDefaultNotificationExecutor((Executor)Executors.swingEDT());
        PVManager.setDefaultDataSource((DataSource)SimulationDataSource.simulatedData());
        this.initComponents();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.valueLabel = new JLabel();
        this.jLabel6 = new JLabel();
        this.scanRateSpinner = new JSpinner();
        this.createPVButton = new JButton();
        this.jLabel3 = new JLabel();
        this.updateRateSpinner = new JSpinner();
        this.avgRateLabel = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel4 = new JLabel();
        this.currentRateLabel = new JLabel();
        this.setDefaultCloseOperation(3);
        this.jLabel1.setText("PV value:");
        this.valueLabel.setText("0");
        this.jLabel6.setText("UI scan rate (Hz):");
        this.scanRateSpinner.setModel(new SpinnerNumberModel(1, 1, 50, 1));
        this.createPVButton.setText("Create ");
        this.createPVButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportRateFrame.this.createPVButtonActionPerformed(evt);
            }
        });
        this.jLabel3.setText("PV update rate (Hz):");
        this.updateRateSpinner.setModel(new SpinnerNumberModel(1, 1, 1000, 1));
        this.avgRateLabel.setText("0");
        this.jLabel2.setText("Avg rate (Hz):");
        this.jLabel4.setText("Current rate (Hz):");
        this.currentRateLabel.setText("0");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.valueLabel, -1, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.updateRateSpinner)).addComponent(this.createPVButton, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jLabel4).addGap(13, 13, 13).addComponent(this.currentRateLabel, -1, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.scanRateSpinner, -2, 155, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, -1, Short.MAX_VALUE).addComponent(this.avgRateLabel, -2, 176, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.valueLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.updateRateSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.scanRateSpinner, -2, -1, -2).addComponent(this.jLabel6)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.avgRateLabel).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.currentRateLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.createPVButton).addContainerGap()));
        this.pack();
    }

    private void createPVButtonActionPerformed(ActionEvent evt) {
        if (this.pv != null) {
            this.pv.close();
        }
        this.overallTimestamp = Timestamp.now();
        this.overallCounter = 0;
        this.lastPeriodTimestamp = this.overallTimestamp;
        this.lastPeriodCounter = 0;
        this.valueLabel.setText("");
        this.avgRateLabel.setText("");
        this.currentRateLabel.setText("");
        double timeIntervalSec = 1.0 / (double)((Integer)this.updateRateSpinner.getModel().getValue()).intValue();
        String pvName = "gaussianNoise(0.0, 1.0, " + timeIntervalSec + ")";
        int scanRate = (Integer)this.scanRateSpinner.getModel().getValue();
        this.pv = PVManager.read((SourceRateExpression)ExpressionLanguage.vDouble((String)pvName)).readListener((PVReaderListener)new PVReaderListener<VDouble>(){

            public void pvChanged(PVReaderEvent<VDouble> event) {
                if (event.isValueChanged()) {
                    ReportRateFrame.this.valueLabel.setText(Double.toString(((VDouble)ReportRateFrame.this.pv.getValue()).getValue()));
                    ReportRateFrame.this.overallCounter++;
                    Timestamp now = Timestamp.now();
                    double avgRage = (double)ReportRateFrame.this.overallCounter / now.durationFrom(ReportRateFrame.this.overallTimestamp).toSeconds();
                    ReportRateFrame.this.avgRateLabel.setText("" + avgRage);
                    if (now.compareTo(ReportRateFrame.this.lastPeriodTimestamp.plus(ReportRateFrame.this.measureInterval)) >= 0) {
                        double currentRate = (double)(ReportRateFrame.this.overallCounter - ReportRateFrame.this.lastPeriodCounter) / now.durationFrom(ReportRateFrame.this.lastPeriodTimestamp).toSeconds();
                        ReportRateFrame.this.currentRateLabel.setText("" + currentRate);
                        ReportRateFrame.this.lastPeriodTimestamp = now;
                        ReportRateFrame.this.lastPeriodCounter = ReportRateFrame.this.overallCounter;
                    }
                }
            }
        }).maxRate(TimeDuration.ofHertz((double)scanRate));
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new ReportRateFrame().setVisible(true);
            }
        });
    }
}

