/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.sample;

import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import org.epics.pvmanager.DataSource;
import org.epics.pvmanager.ExpressionLanguage;
import org.epics.pvmanager.PVManager;
import org.epics.pvmanager.PVReader;
import org.epics.pvmanager.expression.SourceRateExpression;
import org.epics.pvmanager.loc.LocalDataSource;
import org.epics.util.time.TimeDuration;

public class ScannerLoadTest {
    static OperatingSystemMXBean bean = ManagementFactory.getPlatformMXBean(OperatingSystemMXBean.class);

    public static void main(String[] args) throws Exception {
        PVManager.setDefaultDataSource((DataSource)new LocalDataSource());
        System.out.println("nChannels \"timeToStart (ms)\" \"avgLoad (ms)\"");
        for (int i = 0; i < 9; ++i) {
            int nPvs = (int)Math.pow(4.0, i);
            ScannerLoadTest.profile(nPvs);
        }
    }

    public static double measureLoad(int nSec) throws InterruptedException {
        long timeStart = System.currentTimeMillis();
        double totalSum = 0.0;
        int count = 0;
        while (System.currentTimeMillis() - timeStart < (long)(nSec * 1000)) {
            Thread.sleep(250L);
            double load = bean.getProcessCpuLoad();
            if (!(load >= 0.0)) continue;
            totalSum += load;
            ++count;
        }
        return totalSum / (double)count;
    }

    public static void waitForZeroLoad(int timeoutSec) throws InterruptedException {
        long timeStart = System.currentTimeMillis();
        while (System.currentTimeMillis() - timeStart < (long)(timeoutSec * 1000)) {
            double load = bean.getProcessCpuLoad();
            if (load == 0.0) {
                return;
            }
            Thread.sleep(250L);
        }
    }

    public static void profile(int nPvs) throws Exception {
        ArrayList<PVReader> pvs = new ArrayList<PVReader>();
        long timeStart = System.currentTimeMillis();
        for (int i = 0; i < nPvs; ++i) {
            PVReader pv = PVManager.read((SourceRateExpression)ExpressionLanguage.channel((String)("channel " + i))).maxRate(TimeDuration.ofHertz((double)50.0));
            pvs.add(pv);
        }
        long startTime = System.currentTimeMillis() - timeStart;
        double avgLoad = ScannerLoadTest.measureLoad(5);
        System.out.println(nPvs + " " + startTime + " " + avgLoad);
        for (PVReader pv : pvs) {
            pv.close();
        }
        ScannerLoadTest.waitForZeroLoad(5);
    }
}

