/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.sample;

import java.util.concurrent.Executor;
import org.epics.pvmanager.CompositeDataSource;
import org.epics.pvmanager.DataSource;
import org.epics.pvmanager.PVManager;
import org.epics.pvmanager.file.FileDataSource;
import org.epics.pvmanager.formula.ArrayFunctionSet;
import org.epics.pvmanager.formula.FormulaFunctionSet;
import org.epics.pvmanager.formula.FormulaRegistry;
import org.epics.pvmanager.formula.MathFunctionSet;
import org.epics.pvmanager.formula.NumberOperatorFunctionSet;
import org.epics.pvmanager.formula.StringFunctionSet;
import org.epics.pvmanager.formula.TableFunctionSet;
import org.epics.pvmanager.jca.JCADataSourceBuilder;
import org.epics.pvmanager.loc.LocalDataSource;
import org.epics.pvmanager.sim.SimulationDataSource;
import org.epics.pvmanager.sys.SystemDataSource;
import org.epics.pvmanager.util.Executors;

public class SetupUtil {
    public static void defaultCASetup() {
        CompositeDataSource dataSource = new CompositeDataSource();
        dataSource.putDataSource("sim", SimulationDataSource.simulatedData());
        System.setProperty("com.cosylab.epics.caj.CAJContext.max_array_bytes", "10000000");
        dataSource.putDataSource("ca", (DataSource)new JCADataSourceBuilder().build());
        dataSource.putDataSource("loc", (DataSource)new LocalDataSource());
        dataSource.putDataSource("sys", (DataSource)new SystemDataSource());
        dataSource.putDataSource("file", (DataSource)new FileDataSource());
        dataSource.setDefaultDataSource("ca");
        PVManager.setDefaultDataSource((DataSource)dataSource);
        FormulaRegistry.getDefault().registerFormulaFunctionSet((FormulaFunctionSet)new ArrayFunctionSet());
        FormulaRegistry.getDefault().registerFormulaFunctionSet((FormulaFunctionSet)new MathFunctionSet());
        FormulaRegistry.getDefault().registerFormulaFunctionSet((FormulaFunctionSet)new NumberOperatorFunctionSet());
        FormulaRegistry.getDefault().registerFormulaFunctionSet((FormulaFunctionSet)new TableFunctionSet());
        FormulaRegistry.getDefault().registerFormulaFunctionSet((FormulaFunctionSet)new StringFunctionSet());
    }

    public static void defaultCASetupForSwing() {
        PVManager.setDefaultNotificationExecutor((Executor)Executors.swingEDT());
        SetupUtil.defaultCASetup();
    }
}

