/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.sample;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EnumMap;
import java.util.Map;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import org.epics.pvmanager.ChannelHandler;
import org.epics.pvmanager.PVManager;
import org.epics.pvmanager.PVReader;
import org.epics.pvmanager.PVReaderEvent;
import org.epics.pvmanager.PVReaderListener;
import org.epics.pvmanager.expression.DesiredRateExpression;
import org.epics.pvmanager.formula.ExpressionLanguage;
import org.epics.pvmanager.sample.SetupUtil;
import org.epics.util.time.TimeDuration;
import org.epics.vtype.Alarm;
import org.epics.vtype.AlarmSeverity;
import org.epics.vtype.Display;
import org.epics.vtype.SimpleValueFormat;
import org.epics.vtype.Time;
import org.epics.vtype.ValueFormat;
import org.epics.vtype.ValueUtil;

public class SimpleProbe
extends JFrame {
    Map<AlarmSeverity, Border> borders = new EnumMap<AlarmSeverity, Border>(AlarmSeverity.class);
    ValueFormat format = new SimpleValueFormat(3);
    PVReader<?> pv;
    private JButton channelDetailsButton;
    private JTextField connected;
    private JSlider indicator;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JSeparator jSeparator1;
    private JTextField lastError;
    private JTextField metadata;
    private JTextField pvName;
    private JTextField pvTextValue;
    private JTextField pvTime;
    private JTextField pvType;
    private JTextField writeConnected;

    public SimpleProbe() {
        this.initComponents();
        this.borders.put(AlarmSeverity.NONE, this.pvTextValue.getBorder());
        this.borders.put(AlarmSeverity.MINOR, new LineBorder(Color.YELLOW));
        this.borders.put(AlarmSeverity.MAJOR, new LineBorder(Color.RED));
        this.borders.put(AlarmSeverity.INVALID, new LineBorder(Color.GRAY));
        this.borders.put(AlarmSeverity.UNDEFINED, new LineBorder(Color.MAGENTA));
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.pvName = new JTextField();
        this.jLabel3 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jLabel5 = new JLabel();
        this.pvTextValue = new JTextField();
        this.pvType = new JTextField();
        this.lastError = new JTextField();
        this.jLabel4 = new JLabel();
        this.pvTime = new JTextField();
        this.indicator = new JSlider();
        this.jLabel6 = new JLabel();
        this.metadata = new JTextField();
        this.channelDetailsButton = new JButton();
        this.connected = new JTextField();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.writeConnected = new JTextField();
        this.setDefaultCloseOperation(3);
        this.jLabel1.setText("Value:");
        this.jLabel2.setText("PV name:");
        this.pvName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleProbe.this.pvNameActionPerformed(evt);
            }
        });
        this.jLabel3.setText("Last error:");
        this.jLabel5.setText("Type:");
        this.pvTextValue.setEditable(false);
        this.pvType.setEditable(false);
        this.lastError.setEditable(false);
        this.jLabel4.setText("Timestamp:");
        this.pvTime.setEditable(false);
        this.indicator.setEnabled(false);
        this.jLabel6.setText("Metadata:");
        this.metadata.setEditable(false);
        this.channelDetailsButton.setText("Channel details...");
        this.channelDetailsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleProbe.this.channelDetailsButtonActionPerformed(evt);
            }
        });
        this.connected.setEditable(false);
        this.jLabel7.setText("Connected:");
        this.jLabel8.setText("Write Connected:");
        this.writeConnected.setEditable(false);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1, -1, 411, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.pvName, -1, 319, Short.MAX_VALUE)).addComponent(this.indicator, -1, 387, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.pvTextValue, -1, 338, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.pvTime, -1, 306, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.pvType, -1, 342, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.lastError, -1, 314, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.metadata)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.connected)).addGroup(layout.createSequentialGroup().addComponent(this.channelDetailsButton).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel8).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.writeConnected))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.pvName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.indicator, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.pvTextValue, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.pvTime, -2, -1, -2).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.pvType, -2, -1, -2).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lastError, -2, -1, -2).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.metadata, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.connected, -2, -1, -2).addComponent(this.jLabel7)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel8).addComponent(this.writeConnected, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.channelDetailsButton).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void pvNameActionPerformed(ActionEvent evt) {
        long total;
        long startTime = System.currentTimeMillis();
        if (this.pv != null) {
            this.pv.close();
            this.lastError.setText("");
        }
        if ((total = System.currentTimeMillis() - startTime) > 1L) {
            System.out.println("Disconnect took " + total + " ms");
        }
        try {
            startTime = System.currentTimeMillis();
            this.pv = PVManager.read((DesiredRateExpression)ExpressionLanguage.formula((String)this.pvName.getText())).timeout(TimeDuration.ofSeconds((double)5.0)).readListener((PVReaderListener)new PVReaderListener<Object>(){

                public void pvChanged(PVReaderEvent<Object> event) {
                    SimpleProbe.this.setLastError(SimpleProbe.this.pv.lastException());
                    Object value = SimpleProbe.this.pv.getValue();
                    SimpleProbe.this.setTextValue(SimpleProbe.this.format.format(value));
                    SimpleProbe.this.setType(ValueUtil.typeOf((Object)value));
                    SimpleProbe.this.setAlarm(ValueUtil.alarmOf((Object)value));
                    SimpleProbe.this.setTime(ValueUtil.timeOf((Object)value));
                    SimpleProbe.this.setIndicator(ValueUtil.normalizedNumericValueOf((Object)value));
                    SimpleProbe.this.setMetadata(ValueUtil.displayOf((Object)value));
                    SimpleProbe.this.setConnected(SimpleProbe.this.pv.isConnected());
                }
            }).maxRate(TimeDuration.ofHertz((double)10.0));
            total = System.currentTimeMillis() - startTime;
            if (total > 1L) {
                System.out.println("Reconnect took " + total + " ms");
            }
        }
        catch (Throwable t) {
            System.out.println("EXCEPTION WHILE CREATING PV!!! SHOULD NEVER HAPPEN!!!");
            t.printStackTrace();
        }
    }

    private void channelDetailsButtonActionPerformed(ActionEvent evt) {
        try {
            ChannelHandler handler = (ChannelHandler)PVManager.getDefaultDataSource().getChannels().get(this.pvName.getText());
            if (handler != null) {
                Map properties = handler.getProperties();
                StringBuilder builder = new StringBuilder();
                builder.append("Channel properties:\n");
                for (Map.Entry entry : properties.entrySet()) {
                    String string = (String)entry.getKey();
                    Object object = entry.getValue();
                    builder.append(string).append(" = ").append(object).append("\n");
                }
                JOptionPane.showMessageDialog(this, builder.toString());
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
    }

    private void setTextValue(String value) {
        if (value == null) {
            this.pvTextValue.setText("");
        } else {
            this.pvTextValue.setText(value);
        }
    }

    private void setType(Class type) {
        if (type == null) {
            this.pvType.setText("");
        } else {
            this.pvType.setText(type.getSimpleName());
        }
    }

    private void setAlarm(Alarm alarm) {
        if (alarm != null) {
            this.pvTextValue.setBorder(this.borders.get(alarm.getAlarmSeverity()));
        } else {
            this.pvTextValue.setBorder(this.borders.get(AlarmSeverity.NONE));
        }
    }

    private void setTime(Time time) {
        if (time == null) {
            this.pvTime.setText("");
        } else {
            this.pvTime.setText(time.getTimestamp().toDate().toString());
        }
    }

    private void setMetadata(Display display) {
        if (display == null) {
            this.metadata.setText("");
        } else {
            this.metadata.setText(display.getUpperDisplayLimit() + " - " + display.getLowerDisplayLimit());
        }
    }

    private void setLastError(Exception ex) {
        if (ex != null) {
            ex.printStackTrace();
            this.lastError.setText(ex.getClass().getSimpleName() + " " + ex.getMessage());
        }
    }

    private void setConnected(Boolean connected) {
        if (connected != null) {
            this.connected.setText(connected.toString());
        } else {
            this.connected.setText("");
        }
    }

    private void setWriteConnected(Boolean connected) {
        if (connected != null) {
            this.writeConnected.setText(connected.toString());
        } else {
            this.writeConnected.setText("");
        }
    }

    private void setIndicator(Double value) {
        int range = this.indicator.getMaximum() - this.indicator.getMinimum();
        int position = range / 2;
        if (value != null) {
            position = (int)((double)range * value);
        }
        this.indicator.setValue(position);
    }

    public static void main(String[] args) {
        SetupUtil.defaultCASetupForSwing();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new SimpleProbe().setVisible(true);
            }
        });
    }
}

