/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.sample.graphene;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.epics.graphene.Graph2DRendererUpdate;
import org.epics.pvmanager.PVManager;
import org.epics.pvmanager.PVReader;
import org.epics.pvmanager.PVReaderEvent;
import org.epics.pvmanager.PVReaderListener;
import org.epics.pvmanager.graphene.Graph2DExpression;
import org.epics.pvmanager.graphene.Graph2DResult;
import org.epics.pvmanager.sample.ImagePanel;
import org.epics.pvmanager.sample.SetupUtil;
import org.epics.pvmanager.util.Executors;
import org.epics.util.time.TimeDuration;
import org.epics.vtype.VImage;
import org.epics.vtype.ValueUtil;

public abstract class BaseGraphApp<T extends Graph2DRendererUpdate<T>>
extends JFrame {
    private PVReader<Graph2DResult> pv;
    protected Graph2DExpression<T> graph;
    private JButton configureButton;
    protected JComboBox<String> dataFormulaField;
    private ImagePanel imagePanel;
    private JLabel jLabel1;
    private JTextField lastErrorField;

    public BaseGraphApp() {
        SetupUtil.defaultCASetupForSwing();
        this.initComponents();
        this.imagePanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (BaseGraphApp.this.graph != null) {
                    BaseGraphApp.this.graph.update(BaseGraphApp.this.graph.newUpdate().imageHeight(Math.max(1, BaseGraphApp.this.imagePanel.getHeight())).imageWidth(Math.max(1, BaseGraphApp.this.imagePanel.getWidth())));
                }
            }
        });
        this.imagePanel.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                BaseGraphApp.this.onMouseMove(e);
            }
        });
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                BaseGraphApp.this.dataFormulaField.setSelectedIndex(0);
            }
        });
    }

    protected void onMouseMove(MouseEvent e) {
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.dataFormulaField = new JComboBox();
        this.lastErrorField = new JTextField();
        this.imagePanel = new ImagePanel();
        this.configureButton = new JButton();
        this.setDefaultCloseOperation(3);
        this.jLabel1.setText("Data:");
        this.dataFormulaField.setEditable(true);
        this.dataFormulaField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BaseGraphApp.this.dataFormulaFieldActionPerformed(evt);
            }
        });
        this.lastErrorField.setEditable(false);
        GroupLayout imagePanelLayout = new GroupLayout(this.imagePanel);
        this.imagePanel.setLayout(imagePanelLayout);
        imagePanelLayout.setHorizontalGroup(imagePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        imagePanelLayout.setVerticalGroup(imagePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 461, Short.MAX_VALUE));
        this.configureButton.setText("Configure");
        this.configureButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BaseGraphApp.this.configureButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.imagePanel, -1, -1, Short.MAX_VALUE).addComponent(this.lastErrorField, GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.dataFormulaField, 0, 504, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.configureButton))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.dataFormulaField, -2, -1, -2).addComponent(this.configureButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.imagePanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lastErrorField, -2, -1, -2).addContainerGap()));
        this.pack();
    }

    private void dataFormulaFieldActionPerformed(ActionEvent evt) {
        this.reconnect();
    }

    protected void reconnect() {
        if (this.pv != null) {
            this.pv.close();
            this.imagePanel.setImage(null);
            this.graph = null;
        }
        if (this.dataFormulaField.getSelectedItem() == null || this.dataFormulaField.getSelectedItem().toString().trim().isEmpty()) {
            return;
        }
        this.graph = this.createExpression(this.dataFormulaField.getSelectedItem().toString());
        this.graph.update(this.graph.newUpdate().imageHeight(this.imagePanel.getHeight()).imageWidth(this.imagePanel.getWidth()));
        this.pv = PVManager.read(this.graph).notifyOn(Executors.swingEDT()).readListener((PVReaderListener)new PVReaderListener<Graph2DResult>(){

            public void pvChanged(PVReaderEvent<Graph2DResult> event) {
                BaseGraphApp.this.setLastError(BaseGraphApp.this.pv.lastException());
                if (BaseGraphApp.this.pv.getValue() != null) {
                    BufferedImage image = ValueUtil.toImage((VImage)((Graph2DResult)BaseGraphApp.this.pv.getValue()).getImage());
                    BaseGraphApp.this.imagePanel.setImage(image);
                }
            }
        }).maxRate(TimeDuration.ofHertz((double)50.0));
    }

    protected abstract Graph2DExpression<T> createExpression(String var1);

    protected abstract void openConfigurationDialog();

    private void configureButtonActionPerformed(ActionEvent evt) {
        this.openConfigurationDialog();
    }

    private void setLastError(Exception ex) {
        if (ex != null) {
            this.lastErrorField.setText(ex.getMessage());
            ex.printStackTrace();
        } else {
            this.lastErrorField.setText("");
        }
    }

    public static void main(final Class<? extends BaseGraphApp> clazz) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(BaseGraphApp.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(BaseGraphApp.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(BaseGraphApp.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(BaseGraphApp.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    ((BaseGraphApp)clazz.newInstance()).setVisible(true);
                }
                catch (InstantiationException ex) {
                    Logger.getLogger(BaseGraphApp.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (IllegalAccessException ex) {
                    Logger.getLogger(BaseGraphApp.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
    }
}

