/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.sample.graphene;

import java.awt.Frame;
import java.awt.event.MouseEvent;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JFrame;
import org.epics.graphene.BubbleGraph2DRendererUpdate;
import org.epics.graphene.Graph2DRendererUpdate;
import org.epics.pvmanager.expression.DesiredRateExpression;
import org.epics.pvmanager.formula.ExpressionLanguage;
import org.epics.pvmanager.graphene.BubbleGraph2DExpression;
import org.epics.pvmanager.sample.graphene.BaseGraphApp;
import org.epics.pvmanager.sample.graphene.BubbleGraphDialog;

public class BubbleGraphApp
extends BaseGraphApp<BubbleGraph2DRendererUpdate> {
    private String xColumn = null;
    private String yColumn = null;
    private String sizeColumn = null;
    private String colorColumn = null;
    private boolean highlightFocusValue;

    public BubbleGraphApp() {
        this.dataFormulaField.setModel(new DefaultComboBoxModel<String>(new String[]{"=tableOf(column(\"X\", range(-10,10)), column(\"Y\", 'sim://noiseWaveform'), column(\"SIZE\", 'sim://gaussianWaveform'), column(\"COLOR\", 'sim://sineWaveform'))", "=tableOf(column(\"X\", range(-10,10)), column(\"Y\", 'sim://noiseWaveform'))", "=tableOf(column(\"X\", arrayOf(2,3,4,3,2,1,0,1)), column(\"Y\", arrayOf(0,1,2,3,4,3,2,1)), column(\"SIZE\", arrayOf(5,4,3,2,1,2,3,4)), column(\"SIZE\", arrayOf(\"A\",\"A\",\"B\",\"B\",\"B\",\"B\",\"A\",\"A\")))", "=tableOf(column(\"X\", arrayOf(1,2,3,4,5)), column(\"Y\", arrayOf(3,1,4,2,5)), column(\"NAMES\", arrayOf(\"A\", \"A\", \"A\", \"B\", \"B\")))"}));
    }

    @Override
    protected void onMouseMove(MouseEvent e) {
        this.graph.update((Graph2DRendererUpdate)((BubbleGraph2DRendererUpdate)this.graph.newUpdate()).focusPixel(e.getX(), e.getY()));
    }

    protected BubbleGraph2DExpression createExpression(String dataFormula) {
        BubbleGraph2DExpression plot = org.epics.pvmanager.graphene.ExpressionLanguage.bubbleGraphOf((DesiredRateExpression)ExpressionLanguage.formula((String)dataFormula), (DesiredRateExpression)ExpressionLanguage.formulaArg((String)this.xColumn), (DesiredRateExpression)ExpressionLanguage.formulaArg((String)this.yColumn), (DesiredRateExpression)ExpressionLanguage.formulaArg((String)this.sizeColumn), (DesiredRateExpression)ExpressionLanguage.formulaArg((String)this.colorColumn));
        return plot;
    }

    @Override
    protected void openConfigurationDialog() {
        BubbleGraphDialog dialog = new BubbleGraphDialog((Frame)new JFrame(), true, this);
        dialog.setTitle("Configure...");
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
    }

    public boolean isHighlightFocusValue() {
        return this.highlightFocusValue;
    }

    public void setHighlightFocusValue(boolean highlightFocusValue) {
        this.highlightFocusValue = highlightFocusValue;
        this.graph.update((Graph2DRendererUpdate)((BubbleGraph2DRendererUpdate)this.graph.newUpdate()).highlightFocusValue(highlightFocusValue));
    }

    public String getXColumn() {
        return this.xColumn;
    }

    public void setXColumn(String xColumn) {
        this.xColumn = xColumn;
        this.reconnect();
    }

    public String getYColumn() {
        return this.yColumn;
    }

    public void setYColumn(String yColumn) {
        this.yColumn = yColumn;
        this.reconnect();
    }

    public String getSizeColumn() {
        return this.sizeColumn;
    }

    public void setSizeColumn(String sizeColumn) {
        this.sizeColumn = sizeColumn;
        this.reconnect();
    }

    public String getColorColumn() {
        return this.colorColumn;
    }

    public void setColorColumn(String colorColumn) {
        this.colorColumn = colorColumn;
        this.reconnect();
    }

    public static void main(String[] args) {
        BubbleGraphApp.main(BubbleGraphApp.class);
    }
}

