/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.sample.graphene;

import java.awt.Frame;
import java.awt.event.MouseEvent;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JFrame;
import org.epics.graphene.AreaGraph2DRendererUpdate;
import org.epics.graphene.Graph2DRendererUpdate;
import org.epics.pvmanager.expression.DesiredRateExpression;
import org.epics.pvmanager.formula.ExpressionLanguage;
import org.epics.pvmanager.graphene.HistogramGraph2DExpression;
import org.epics.pvmanager.sample.graphene.BaseGraphApp;
import org.epics.pvmanager.sample.graphene.HistogramGraphDialog;

public class HistogramGraphApp
extends BaseGraphApp<AreaGraph2DRendererUpdate> {
    private boolean highlightFocusValue;

    public HistogramGraphApp() {
        this.dataFormulaField.setModel(new DefaultComboBoxModel<String>(new String[]{"sim://gaussianWaveform", "=histogramOf('sim://noiseWaveform')", "=arrayWithBoundaries(arrayOf(1,3,2,4,3,5), range(-10,10))", "=caHistogram(\"histo\")"}));
    }

    protected HistogramGraph2DExpression createExpression(String dataFormula) {
        HistogramGraph2DExpression plot = org.epics.pvmanager.graphene.ExpressionLanguage.histogramGraphOf((DesiredRateExpression)ExpressionLanguage.formula((String)dataFormula));
        plot.update(plot.newUpdate().highlightFocusValue(this.highlightFocusValue));
        return plot;
    }

    @Override
    protected void onMouseMove(MouseEvent e) {
        this.graph.update((Graph2DRendererUpdate)((AreaGraph2DRendererUpdate)this.graph.newUpdate()).focusPixel(e.getX()));
    }

    public boolean isHighlightFocusValue() {
        return this.highlightFocusValue;
    }

    public void setHighlightFocusValue(boolean highlightFocusValue) {
        this.highlightFocusValue = highlightFocusValue;
        this.graph.update((Graph2DRendererUpdate)((AreaGraph2DRendererUpdate)this.graph.newUpdate()).highlightFocusValue(highlightFocusValue));
    }

    @Override
    protected void openConfigurationDialog() {
        HistogramGraphDialog dialog = new HistogramGraphDialog((Frame)new JFrame(), true, this);
        dialog.setTitle("Configure...");
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
    }

    public static void main(String[] args) {
        HistogramGraphApp.main(HistogramGraphApp.class);
    }
}

