/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.sample.graphene;

import java.awt.Frame;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JFrame;
import org.epics.graphene.Graph2DRendererUpdate;
import org.epics.graphene.IntensityGraph2DRenderer;
import org.epics.graphene.IntensityGraph2DRendererUpdate;
import org.epics.graphene.NumberColorMap;
import org.epics.pvmanager.expression.DesiredRateExpression;
import org.epics.pvmanager.formula.ExpressionLanguage;
import org.epics.pvmanager.graphene.Graph2DExpression;
import org.epics.pvmanager.graphene.IntensityGraph2DExpression;
import org.epics.pvmanager.sample.graphene.BaseGraphApp;
import org.epics.pvmanager.sample.graphene.IntensityGraphDialog;

public class IntensityGraphApp
extends BaseGraphApp<IntensityGraph2DRendererUpdate> {
    private NumberColorMap colorMap = IntensityGraph2DRenderer.DEFAULT_COLOR_MAP;
    private boolean drawLegend = IntensityGraph2DRenderer.DEFAULT_DRAW_LEGEND;

    public IntensityGraphApp() {
        this.dataFormulaField.setModel(new DefaultComboBoxModel<String>(new String[]{"sim://gaussianWaveform", "sim://sine2DWaveform(1,50,45,100,100,0.1)", "=ndArray(arrayOf(1,3,2,4,3,5), dimDisplay(3,FALSE), dimDisplay(2,FALSE))", "=ndArray('13SIM1:image1:ArrayData', dimDisplay('13SIM1:cam1:ArraySizeY_RBV', TRUE), dimDisplay('13SIM1:cam1:ArraySizeX_RBV', FALSE))", "=histogram2DOf(tableOf(column(\"X\", 'sim://sineWaveform(1,100,100,0.01)'), column(\"Y\", 'sim://sineWaveform(10,100,100,0.01)')), \"Y\", \"X\")", "sim://square2DWaveform(1,50,45,10000,10000,0.1)"}));
    }

    protected void updateGraph() {
        if (this.graph != null) {
            this.update((Graph2DExpression<IntensityGraph2DRendererUpdate>)this.graph);
        }
    }

    protected void update(Graph2DExpression<IntensityGraph2DRendererUpdate> graph) {
        graph.update((Graph2DRendererUpdate)((IntensityGraph2DRendererUpdate)graph.newUpdate()).colorMap(this.colorMap).drawLegend(this.drawLegend));
    }

    protected IntensityGraph2DExpression createExpression(String dataFormula) {
        IntensityGraph2DExpression plot = org.epics.pvmanager.graphene.ExpressionLanguage.intensityGraphOf((DesiredRateExpression)ExpressionLanguage.formula((String)dataFormula));
        plot.update(plot.newUpdate().colorMap(this.colorMap));
        return plot;
    }

    public NumberColorMap getColorMap() {
        return this.colorMap;
    }

    public void setColorMap(NumberColorMap colorMap) {
        this.colorMap = colorMap;
        this.updateGraph();
    }

    public boolean isDrawLegend() {
        return this.drawLegend;
    }

    public void setDrawLegend(boolean drawLegend) {
        this.drawLegend = drawLegend;
        this.updateGraph();
    }

    @Override
    protected void openConfigurationDialog() {
        IntensityGraphDialog dialog = new IntensityGraphDialog((Frame)new JFrame(), true, this);
        dialog.setTitle("Configure...");
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
    }

    public static void main(String[] args) {
        IntensityGraphApp.main(IntensityGraphApp.class);
    }
}

